% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/qqnormSim.R
\docType{methods}
\name{qqnormSim}
\alias{qqnormSim}
\alias{qqnormSim,lm-method}
\alias{qqnormSim,numeric-method}
\title{Quantile-Quantile plot with several Gaussian simulations.}
\usage{
qqnormSim(x, nSim = 500, mOfVar = "mad",
  main = "Normal Q-Q Plot - SIM", xlab = "Theoretical Quantiles",
  ylab = "Sample Quantiles", qqnormCol = "black", qqnormPch = 1,
  qqlineCol = "#cdd2d015", qqlineLwd = 3)

\S4method{qqnormSim}{lm}(x, nSim = 500, mOfVar = "mad",
  main = "Normal Q-Q Plot - SIM", xlab = "Theoretical Quantiles",
  ylab = "Sample Quantiles", qqnormCol = "black", qqnormPch = 1,
  qqlineCol = "#cdd2d015", qqlineLwd = 3)

\S4method{qqnormSim}{numeric}(x, nSim = 500, mOfVar = "mad",
  main = "Normal Q-Q Plot - SIM", xlab = "Theoretical Quantiles",
  ylab = "Sample Quantiles", qqnormCol = "black", qqnormPch = 1,
  qqlineCol = "#cdd2d015", qqlineLwd = 3)
}
\arguments{
\item{x}{a lm-object or a numeric vector. If it's a lm-object its residuals are plotted.}

\item{nSim}{\emph{[optional]} the number of simulations you like to add to the plot.}

\item{mOfVar}{\emph{[optinal]} a measure of variation. ("mad" or "sd")}

\item{main}{\emph{[optional]} an overall title for the plot.}

\item{xlab}{\emph{[optional]} a title for the x axis.}

\item{ylab}{\emph{[optional]} a title for the y axis.}

\item{qqnormCol}{\emph{[optional]} color of the obervations in the plot.}

\item{qqnormPch}{\emph{[optional]} point character of the observations in the plot.}

\item{qqlineCol}{\emph{[optional]} color of the simulations in the plot.}

\item{qqlineLwd}{\emph{[optional]} line width of the simulations. should not be higher than 3.}
}
\value{
invisible(NULL)
}
\description{
Plots a QQ plot of the variable x with nSim Gaussian simulations.
}
\details{
Two estimators are required for the simulation of the normal distribution. Since the normal distribution is a two-parameter family distribution.
Default measure of location is the mean. Default measure of variation is the mad. This gives a robust estimation of the standard deviation even if there are outliers in the sample. 
Likewise this can be changed with the parameter \code{mOfVar}.
}
\examples{
\dontrun{

######## qqnorm vs. qqnormSim ########

par(mfrow = c(1,2))
x<- rnorm(100)
qqnorm(x)
qqline(x)
qqnormSim(x)
par(mfrow = c(1,1))

######## basic functionality/arguments ########

# The observations should behave like a simulation, 
# because the observations are sampled from a Gaussian distribution.
qqnormSim(x = rnorm(100))

# If you don't feel comfortable with the mad as 
# measure of variation you can change it to the standard deviation.
qqnormSim(x = rnorm(100),
          mOfVar = "sd")

# On the first glance its obvious that this sample 
# doesn't originate from a Gaussian distribution due to the heavy tails.
qqnormSim(x = rt(100,df = 4))

Reduce the simulation tracks from 500 to 50. (500 is default).
Not recommended unless you have not enough computation power.
qqnormSim(x = rnorm(100), 
          nSim = 50)

######## graphical arguments ########

# set title and axes labels.
qqnormSim(x = rnorm(100), 
          main = "main title",
          xlab = "x-axis label",
          ylab = "y-axis label")
          
# I don't recommend fancy colors, unless you need it for your corporate identity.
qqnormSim(x = rnorm(100), 
          qqnormCol = "#ff0000",
          qqnormPch = 16,
          qqlineCol = "greenyellow",
          qqlineLwd = 1)

}
}
\seealso{
the basic graph corresponds to \link[stats]{qqnorm}
}
\author{
Matthias Salvisberg <matthias.salvisberg@gmail.com>
}
\keyword{qqnorm}
