% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/meth_is_spline.R, R/meth_is_spline_0ld.R
\name{is.splinets}
\alias{is.splinets}
\title{Diagnostics of splines and their generic correction}
\usage{
is.splinets(object)

is.splinets(object)
}
\arguments{
\item{object}{\code{Splinets} object, the object to be diagnosed; For this object to be corrected properly each support interval has to have at least \code{2*smorder+4} knots.}
}
\value{
A list made of: a logical value \code{is}, a \code{Splinets} object \code{robject}, a numeric value \code{Er}, and a string \code{Report}.
\itemize{
\item The logical value \code{is} indicates if all the condtions for the elements of \code{Splinets} object to be a collection of valid
splines are satisfied, additional diagnostic messages are printed out.
\item The object \code{robject} is a modified input object that has all SLOT fields modified so the conditions/restrictions
to be a proper spline are satisfied.
\item The numeric value \code{Er} is giving the total squared error of deviation of the input matrix of derivative from the conditions required for a spline. 
\item The string \code{Report} contains a detailed report on the diagnostic, use \code{cat(is.splinet$Report)} to print out the report. 
}

A list made of: a logical value \code{is}, a \code{Splinets} object \code{robject}, and a numeric value \code{Er}.
\itemize{
\item The logical value \code{is} indicates if all the condtions for the elements of \code{Splinets} object to be a collection of valid
splines are satisfied, additional diagnostic messages are printed out.
\item The object \code{robject} is a modified input object that has all SLOT fields modified so the conditions/restrictions
to be a proper spline are satisfied.
\item The numeric value \code{Er} is giving the total squared error of deviation of the input matrix of derivative from the conditions required for a spline. 
}
}
\description{
The method performs verification of the properties of SLOTS of an object belonging to the
\code{Splinets}--class. In the case when all the properties are satisfied the logical \code{TRUE} is returned. Otherwise,
\code{FALSE} is returned together with suggested corrections.

The method performs verification of the properties of SLOTS of an object belonging to the
\code{Splinets}--class. In the case when all the properties are satisfied the logical \code{TRUE} is returned. Otherwise,
\code{FALSE} is returned together with suggested corrections.
}
\section{References}{

Liu, X., Nassar, H., Podg\eqn{\mbox{\'o}}{o}rski, K. (2019) "Splinets -- efficient orthonormalization of the B-splines."  <arXiv:1910.07341>.

Podg\eqn{\mbox{\'o}}{o}rski, K. (2021) 
"\code{Splinets} -- splines through the Taylor expansion, their support sets and orthogonal bases." <arXiv:2102.00733>.


Liu, X., Nassar, H., Podg\eqn{\mbox{\'o}}{o}rski, K. (2019) "Splinets -- efficient orthonormalization of the B-splines."  <arXiv:1910.07341>.

Podg\eqn{\mbox{\'o}}{o}rski, K. (2021) 
"\code{Splinets} -- splines through the Taylor expansion, their support sets and orthogonal bases." <arXiv:2102.00733>.
}

\examples{
#-----------------------------------------------------#
#--------Diagnostics of simple Splinets objects-------#
#-----------------------------------------------------#
#----------Full support equidistant cases-------------#
#-----------------------------------------------------#
#Zero order splines, equidistant case, full support
n=20; xi=seq(0,1,by=1/(n+1))
sp=new("Splinets",knots=xi) 
sp@equid #equidistance flag
#Diagnostic of 'Splinets' object 'sp'
is.splinets(sp)


IS=is.splinets(sp)
IS[[1]] #informs if the object is a spline
IS$is   #equivalent to the above

cat(IS$Report) #printing the diagnostic report into the terminal

#Third order splines with a noisy matrix of the derivative
set.seed(5)
k=3; sp@smorder=k; sp@der[[1]]=matrix(rnorm((n+2)*(k+1)),ncol=(k+1))

IS=is.splinets(sp)
IS[[2]]@taylor #corrections
sp@taylor
IS[[2]]@der #corrections
sp@der

cat(IS$Report) #printing the diagnostic report into the terminal

is.splinets(IS[[2]]) #The output object is a valid 'Splinets'-object

#-----------------------------------------------------#
#--------Full support non-equidistant cases-----------#
#-----------------------------------------------------#
#Zero order splines, non-equidistant case, full support
set.seed(5)
n=17; xi=sort(runif(n+2))
xi[1]=0 ;xi[n+1]=1 #The last knot is not in the order.
          #It will be reported and corrected in the output.  
sp=new("Splinets",knots=xi) 

xi #original knots
sp@knots #vs. corrected ones
sp@taylor

#Diagnostic of 'Splinets' object 'sp'

IS=is.splinets(sp)

cat(IS$Report) 

nsp=IS$robject #the output spline -- a corrected version of the input
nsp@der
sp@der

#Third order splines
nsp@smorder=3
IS=is.splinets(nsp)

IS[[2]]@taylor #corrections
nsp@taylor
IS[[2]]@der #corrections
nsp@der
is.splinets(IS[[2]]) #verification that the correction is a valid object

#Randomly assigning the derivative -- a very 'unstable' function.
set.seed(5)
k=nsp@smorder; S=matrix(rnorm((n+2)*(k+1)),ncol=(k+1)); nsp@der[[1]]=S

IS=is.splinets(nsp) #the 2nd element of 'IS' is a spline obtained by correcting 'S'
nsp=is.splinets(IS[[2]])
nsp$is #The 'Splinets' object is correct, alternatively use 'nsp$[[1]]'.
nsp$robject #A correct spline object, alternatively use 'nsp$[[2]]'.

#-----------------------------------------------------#
#-----Splinets objects with varying support sets------#
#-----------------------------------------------------#
#-----------------Eequidistant cases------------------#
#-----------------------------------------------------#
#Zero order splines, equidistant case, support with three components
n=20; xi=seq(0,1,by=1/(n+1))
support=list(matrix(c(2,5,6,8,12,18),ncol=2,byrow = TRUE)) 
sp=new("Splinets",knots=xi,supp=support) 
is.splinets(sp)

IS=is.splinets(sp)
cat(IS$Report)

sum(sp@supp[[1]][,2]-sp@supp[[1]][,1]+1) #the number of knots in the support
dim(IS[[2]]@der[[1]])[1]  #the number of rows in the derivative matrix
IS[[2]]@der[[1]] #the corrected object
sp@der #the input derivative matrix

#Third order splines
n=40; xi=seq(0,1,by=1/(n+1)); k=3; 
support=list(matrix(c(2,12,15,27,30,40),ncol=2,byrow = TRUE))
m=sum(support[[1]][,2]-support[[1]][,1]+1) #the number of knots in the support
SS=list(matrix(rnorm(m*(k+1)),ncol=(k+1))) #the derivative matrix at random

sp=new("Splinets",knots=xi,smorder=k,supp=support,der=SS) 

IS=is.splinets(sp)
cat(IS$Report)

m=sum(sp@supp[[1]][,2]-sp@supp[[1]][,1]+1) #the number of knots in the support
sp@der=list(matrix(rnorm(m*(k+1)),ncol=(k+1))) #the derivative matrix at random

IS=is.splinets(sp) #Comparison of the corrected and the original 'der' matrices
sp@der
IS[[2]]@der
is.splinets(IS[[2]]) #verification

#-----------------------------------------------------#
#----------------Non-equidistant cases----------------#
#-----------------------------------------------------#
#Zero order splines, non-equidistant case, support with three components
set.seed(5)
n=43; xi=seq(0,1,by=1/(n+1)); k=3; xi=sort(runif(n+2)); xi[1]=0; xi[n+2]=1;
support=list(matrix(c(2,14,17,30,32,43),ncol=2,byrow = TRUE))

ssp=new("Splinets",knots=xi,supp=support) #with partial support
nssp=is.splinets(ssp)$robject
nssp@supp
nssp@der

#Third order splines
nssp@smorder=3 #changing the order of the 'Splinets' object
set.seed(5)
m=sum(nssp@supp[[1]][,2]-nssp@supp[[1]][,1]+1) #the number of knots in the support
nssp@der=list(matrix(rnorm(m*(k+1)),ncol=(k+1)))  #the derivative matrix at random
IS=is.splinets(nssp) 
IS$robject@der
is.splinets(IS$robject)$is #verification of the corrected output object

#-----------------------------------------------------#
#--------Diagnostics of simple Splinets objects-------#
#-----------------------------------------------------#
#----------Full support equidistant cases-------------#
#-----------------------------------------------------#
#Zero order splines, equidistant case, full support
n=20; xi=seq(0,1,by=1/(n+1))
sp=new("Splinets",knots=xi) 
sp@equid #equidistance flag
#Diagnostic of 'Splinets' object 'sp'
is.splinets(sp)


IS=is.splinets(sp)
IS[[1]] #informs if the object is a spline
IS$is   #equivalent to the above

cat(IS$Report) #printing the diagnostic report into the terminal

#Third order splines with a noisy matrix of the derivative
set.seed(5)
k=3; sp@smorder=k; sp@der[[1]]=matrix(rnorm((n+2)*(k+1)),ncol=(k+1))

IS=is.splinets(sp)
IS[[2]]@taylor #corrections
sp@taylor
IS[[2]]@der #corrections
sp@der

cat(IS$Report) #printing the diagnostic report into the terminal

is.splinets(IS[[2]]) #The output object is a valid 'Splinets'-object

#-----------------------------------------------------#
#--------Full support non-equidistant cases-----------#
#-----------------------------------------------------#
#Zero order splines, non-equidistant case, full support
set.seed(5)
n=17; xi=sort(runif(n+2))
xi[1]=0 ;xi[n+1]=1 #The last knot is not in the order.
          #It will be reported and corrected in the output.  
sp=new("Splinets",knots=xi) 

xi #original knots
sp@knots #vs. corrected ones
sp@taylor

#Diagnostic of 'Splinets' object 'sp'

IS=is.splinets(sp)

cat(IS$Report) 

nsp=IS$robject #the output spline -- a corrected version of the input
nsp@der
sp@der

#Third order splines
nsp@smorder=3
IS=is.splinets(nsp)

IS[[2]]@taylor #corrections
nsp@taylor
IS[[2]]@der #corrections
nsp@der
is.splinets(IS[[2]]) #verification that the correction is a valid object

#Randomly assigning the derivative -- a very 'unstable' function.
set.seed(5)
k=nsp@smorder; S=matrix(rnorm((n+2)*(k+1)),ncol=(k+1)); nsp@der[[1]]=S

IS=is.splinets(nsp) #the 2nd element of 'IS' is a spline obtained by correcting 'S'
nsp=is.splinets(IS[[2]])
nsp$is #The 'Splinets' object is correct, alternatively use 'nsp$[[1]]'.
nsp$robject #A correct spline object, alternatively use 'nsp$[[2]]'.

#-----------------------------------------------------#
#-----Splinets objects with varying support sets------#
#-----------------------------------------------------#
#-----------------Eequidistant cases------------------#
#-----------------------------------------------------#
#Zero order splines, equidistant case, support with three components
n=20; xi=seq(0,1,by=1/(n+1))
support=list(matrix(c(2,5,6,8,12,18),ncol=2,byrow = TRUE)) 
sp=new("Splinets",knots=xi,supp=support) 
is.splinets(sp)

IS=is.splinets(sp)
cat(IS$Report)

sum(sp@supp[[1]][,2]-sp@supp[[1]][,1]+1) #the number of knots in the support
dim(IS[[2]]@der[[1]])[1]  #the number of rows in the derivative matrix
IS[[2]]@der[[1]] #the corrected object
sp@der #the input derivative matrix

#Third order splines
n=40; xi=seq(0,1,by=1/(n+1)); k=3; 
support=list(matrix(c(2,12,15,27,30,40),ncol=2,byrow = TRUE))
m=sum(support[[1]][,2]-support[[1]][,1]+1) #the number of knots in the support
SS=list(matrix(rnorm(m*(k+1)),ncol=(k+1))) #the derivative matrix at random

sp=new("Splinets",knots=xi,smorder=k,supp=support,der=SS) 

IS=is.splinets(sp)
cat(IS$Report)

m=sum(sp@supp[[1]][,2]-sp@supp[[1]][,1]+1) #the number of knots in the support
sp@der=list(matrix(rnorm(m*(k+1)),ncol=(k+1))) #the derivative matrix at random

IS=is.splinets(sp) #Comparison of the corrected and the original 'der' matrices
sp@der
IS[[2]]@der
is.splinets(IS[[2]]) #verification

#-----------------------------------------------------#
#----------------Non-equidistant cases----------------#
#-----------------------------------------------------#
#Zero order splines, non-equidistant case, support with three components
set.seed(5)
n=43; xi=seq(0,1,by=1/(n+1)); k=3; xi=sort(runif(n+2)); xi[1]=0; xi[n+2]=1;
support=list(matrix(c(2,14,17,30,32,43),ncol=2,byrow = TRUE))

ssp=new("Splinets",knots=xi,supp=support) #with partial support
nssp=is.splinets(ssp)$robject
nssp@supp
nssp@der

#Third order splines
nssp@smorder=3 #changing the order of the 'Splinets' object
set.seed(5)
m=sum(nssp@supp[[1]][,2]-nssp@supp[[1]][,1]+1) #the number of knots in the support
nssp@der=list(matrix(rnorm(m*(k+1)),ncol=(k+1)))  #the derivative matrix at random
IS=is.splinets(nssp) 
IS$robject@der
is.splinets(IS$robject)$is #verification of the corrected output object

}
\seealso{
\code{\link{Splinets-class}} for the definition of the \code{Splinets}-class;
\code{\link{construct}} for constructing such an object from the class;
\code{\link{gather}} and \code{\link{subsample}}  for combining and subsampling \code{Splinets}-objects, respectively;
\code{\link{plot,Splinets-method}} for plotting \code{Splinets} objects;

\code{\link{Splinets-class}} for the definition of the \code{Splinets}-class;
\code{\link{construct}} for constructing such an object from the class;
\code{\link{gather}} and \code{\link{subsample}}  for combining and subsampling \code{Splinets}-objects, respectively;
\code{\link{plot,Splinets-method}} for plotting \code{Splinets} objects;
}
