% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plots.R
\name{DefShotSeasonGraphTeam}
\alias{DefShotSeasonGraphTeam}
\title{Generates an defensive shot chart for a given team}
\usage{
DefShotSeasonGraphTeam(Seasondata, team, quant = 0.4, type = "PPS")
}
\arguments{
\item{Seasondata}{a data frame with the details of the season}

\item{team}{the name of the team that you want to make a graph of}

\item{quant}{the quantile of shots to be graphed, defaults to 0.4}

\item{type}{either "PPS" for points per shot or "PCT" for percentage}
}
\value{
a shot chart graph
}
\description{
Creates a defensive Shot Chart for the desired team on a given season, that
is a shot chart of the shots the team recieves during the year
}
\examples{
data("season2017")
#Examples with several teams
DefShotSeasonGraphTeam(season2017, team = "Sas")
DefShotSeasonGraphTeam(season2017, team = "Cle")
#Examples with shooting percentage instead of Points per Shot
DefShotSeasonGraphTeam(season2017, team = "Cle", type = "PCT")
}
\author{
Derek Corcoran <derek.corcoran.barrios@gmail.com>
}
