% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/batty_karlstrom_entropy.R
\name{karlstrom}
\alias{karlstrom}
\title{Karlstrom and Ceccato's entropy.}
\usage{
karlstrom(data, data.assign, category, G.coords, neigh.dist)
}
\arguments{
\item{data}{A data matrix or vector, can be numeric, factor, character, ...
If the dataset is a point pattern, \code{data} is the mark vector.}

\item{data.assign}{A three column matrix, containing the data coordinates (centroids when pixels)
and the id of the corresponding sub-area. Provided by user or returned by \code{\link[=areapart]{areapart()}}.}

\item{category}{A character string, the exact name of the category for which Karlstrom and Ceccato's spatial
entropy is computed, as in \code{data}.}

\item{G.coords}{A point pattern (an object of class \code{ppp} see package \code{spatstat}),
or a two column matrix with the area centroids' coordinates.  Provided by user or returned by \code{\link[=areapart]{areapart()}}.}

\item{neigh.dist}{A scalar, the chosen neighbourhood Euclidean distance.}
}
\value{
Karlstrom and Ceccato's spatial entropy value as well as a table with information about each sub-area:
\itemize{
\item \code{area.id} the sub-area id
\item \code{abs.freq} the number of points/pixels presenting the category of interest
for each sub-area
\item \code{rel.freq} the proportion of points/pixels presenting the category of interest
in each sub-area, with regard to the total number of points/pixels with the
category of interest
\item \code{p.tilde} the probability of occurrence over area \eqn{g} weighted with its neighbours.
}
}
\description{
This function computes Karlstrom and Ceccato's spatial entropy for a
chosen neighbourhood distance,
following Karlstrom and Ceccato (2002), see also Altieri et al (2017)
(references are under the topic \code{\link{SpatEntropy}}).
}
\details{
Karlstrom and Ceccato's spatial entropy measures the heterogeneity in the spatial distribution
of a phenomenon of interest, with regard to an area partition and accounting for the neighbourhood.
It is similar to Batty's entropy (see \code{\link[=batty]{batty()}}) discarding the sub-area size,
with the difference that the probability of occurrence of the phenomenon over area \eqn{g}
is actually a weighted sum of the neighbouring probabilities.
When data are categorical, the phenomenon of interest corresponds to
one category, which must be specified. If data are an unmarked
point pattern, a fake mark vector must be created with the same category for all points.
}
\examples{
#LATTICE DATA
data.lat=matrix(sample(c("a","b","c"), 100, replace=TRUE), nrow=10)
ccc=coords_pix(area=square(10), nrow=10, ncol=10)
partition=areapart(square(10), G=5, data.coords=ccc)
karlstrom(data.lat, partition$data.assign, category="a",
G.coords=partition$G.coords, neigh.dist=2)
plot_areapart(partition$data.assign, square(10), is.pointdata=FALSE,
add.data=TRUE, data.bin=TRUE, category="a",
data=data.lat, G.coords=partition$G.coords, main="")

#POINT DATA
data.pp=runifpoint(100, win=square(10))
marks(data.pp)=sample(c("a","b","c"), 100, replace=TRUE)
ccc=coords(data.pp)
partition=areapart(square(10), G=4, data.coords=ccc)
karlstrom(marks(data.pp), partition$data.assign,
category="b", G.coords=partition$G.coords, neigh.dist=4)
plot_areapart(partition$data.assign, square(10), is.pointdata=TRUE,
add.data=TRUE, data.bin=TRUE, category="b",
data=data.pp, G.coords=partition$G.coords, main="")

}
