% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/routines.R
\name{removenoninformativelists}
\alias{removenoninformativelists}
\title{Remove non-informative list}
\usage{
removenoninformativelists(zdat)
}
\arguments{
\item{zdat}{Data matrix with \eqn{t+1} columns. The first \eqn{t} columns, each corresponding to a particular list,
are 0s and 1s defining the capture histories
observed. The last column is the count of cases with that particular capture history.}
}
\value{
data matrix that contains no duplicate lists, no lists with no data, and no lists that contain all the observed data.
If all lists are removed, the total count is returned.
}
\description{
The routine cleans up the data set by removing any lists that contain no data, any lists which contain all the observed data, and
 any list whose results duplicate those of another list.
  If as a result the original data set has no list left, it returns a matrix with the value of the total count.
}
