% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utils.R
\name{alloc}
\alias{alloc}
\title{Allocate values to "buckets" subject to weights and constraints}
\usage{
alloc(tgt, bucketLims, ws = rep(1/length(bucketLims), length(bucketLims)))
}
\arguments{
\item{tgt}{Value to distribute between buckets.}

\item{bucketLims}{The maximum value that each bucket can take.  Must be a vector of positive values.}

\item{ws}{Weights to be used for each bucket.  Default value makes all buckets equally likely.}
}
\value{
A vector of the same length as \code{bucketLims} containing values distributed into buckets.
}
\description{
Allocates \code{tgt} of something to \code{length(bucketLims)} different "buckets" subject to the constraint that each bucket has a maximum value of \code{bucketLims} that cannot be exceeded.  By default counts are distributed equally between buckets, but weights can be provided using \code{ws} to have the redistribution prefer certain buckets over others.
}
