% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data.R
\docType{data}
\name{PBMC_sc}
\alias{PBMC_sc}
\title{SoupChannel from PBMC data}
\format{
\code{PBMC_sc} is a \code{SoupChannel} object with 33,694 genes and 2,170 cells.
}
\source{
\url{https://support.10xgenomics.com/single-cell-gene-expression/datasets/2.1.0/pbmc4k}
}
\usage{
data(PBMC_sc)
}
\description{
\code{\link{SoupChannel}} created from 10X demonstration PBMC 4k data.  The cells have been sub-sampled by a factor of 2 to reduce file size of package.
}
\details{
\code{PBMC_sc} was created by running the following commands.
\itemize{
  \item \code{set.seed(1137)}
  \item \code{tmpDir = tempdir(check=TRUE)}
  \item \code{download.file('http://cf.10xgenomics.com/samples/cell-exp/2.1.0/pbmc4k/pbmc4k_raw_gene_bc_matrices.tar.gz',destfile=file.path(tmpDir,'tod.tar.gz'))}
  \item \code{download.file('http://cf.10xgenomics.com/samples/cell-exp/2.1.0/pbmc4k/pbmc4k_filtered_gene_bc_matrices.tar.gz',destfile=file.path(tmpDir,'toc.tar.gz'))}
  \item \code{untar(file.path(tmpDir,'tod.tar.gz'),exdir=tmpDir)}
  \item \code{untar(file.path(tmpDir,'toc.tar.gz'),exdir=tmpDir)}
  \item \code{library(SoupX)}
  \item \code{PBMC_sc = load10X(tmpDir,calcSoupProfile=FALSE)}
  \item \code{PBMC_sc = SoupChannel(PBMC_sc$tod,PBMC_sc$toc[,sample(ncol(PBMC_sc$toc),round(ncol(PBMC_sc$toc)*0.5))])}
}
}
\keyword{datasets}
