% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/SkeweDF_functions.R
\name{skeweDF_auto}
\alias{skeweDF_auto}
\title{SkeweDF Auto Helper Function}
\usage{
skeweDF_auto(
  title = "Dataset",
  data,
  xlab = "Random Variable",
  param_bounds,
  model_fn_name,
  left_trunc = 1,
  right_trunc = left_trunc + length(data) - 1,
  n_cores = 1
)
}
\arguments{
\item{title}{Character vector indicating title of the empirical dataset, this will be present on every plot, this also determines the name of the folder where plots will be}

\item{data}{Vector of observed values}

\item{xlab}{Character vector indicating x axis label of plots, indicates what the random variable is}

\item{param_bounds}{A list of sequences which indicate space where parameters should be generated and fit}

\item{model_fn_name}{Character vector used to indicate name of model function used for optimization}

\item{left_trunc}{Int used to determine starting index of model to use for optimization}

\item{right_trunc}{Int used to determine ending index of model to use for optimization}

\item{n_cores}{Integer used to indicate number of cores to be used for this function if a socket cluster object is not defined.}
}
\description{
This function will automatically optimize parameters for an empirical dataset given a model function and generate plots and tables
}
