% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/simul.next.resident.R
\name{simul.next.resident}
\alias{simul.next.resident}
\title{Time step simulation (next resident values)}
\usage{
simul.next.resident(E_res_fun, kin_fun, Keq_fun, N_fun,
correl_fun, beta_fun=NULL, X_fun=1, max_mut_size_E=1, max_mut_size_A=1,
pmutA=0, typ_E=1, typ_A=1, use.old.mut=FALSE)
}
\arguments{
\item{E_res_fun}{Numeric vector of enzyme concentrations (resident)}

\item{kin_fun}{Numeric vector of kinetic parameters (catalytic constant kcat divided by Michaelis constant Km)}

\item{Keq_fun}{Numeric vector of equilibrium constants}

\item{N_fun}{Numeric. Population size}

\item{correl_fun}{Character string indicating the abbreviation of the constraint applied on the system}

\item{beta_fun}{Matrix of co-regulation coefficients}

\item{X_fun}{Numeric. Numerator of function \code{\link{flux}}. Default is 1}

\item{max_mut_size_E}{Numeric. Maximum absolute size of mutation for enzyme concentrations. Default is 1}

\item{max_mut_size_A}{Numeric. Maximum absolute size of mutation for kinetic parameters. Default is 1}

\item{pmutA}{Numeric. Mutation probability of kinetic parameters.
Higher \code{pmutA}, higher the mutation probability of kinetic parameters compared to enzyme concentrations.
Default is 0, i.e. no mutation of kinetic parameters}

\item{typ_E}{Numeric for mutation method. Authorized values: 1 or 2. Default is 1.}

\item{typ_A}{Numeric for mutation method. Default is 1. \emph{See details in \code{\link{mut.kin}}.}}

\item{use.old.mut}{Logical. If \code{FALSE} (default), use \code{\link{mut.E.direct}} mutation method, else use \code{\link{mut.E.old}} mutation method if \code{TRUE}}
}
\value{
Returns a list of 7 elements:
\itemize{
   \item \code{$E_next}: numeric vector (length \code{n}) of the enzyme concentrations of next resident
   \item \code{$kin_next}: numeric vector (length \code{n}) of the kinetic parameters of next resident
   \item \code{$Etot_next}: numeric, the total concentration of next resident
   \item \code{$kintot_next}: numeric, the total kinetic of next resident
   \item \code{$J_next}: numeric, flux of next resident
   \item \code{$size_mut}: numeric, mutation size, even if it is not fixed
   \item \code{$target_mut}: numeric, number of enzyme targeted by the mutation
}

Note that \code{n} is the number of enzymes, which is the length of \code{E_res_fun}.
}
\description{
\code{simul.next.resident} simulates a time step, i.e. computes effects of a new mutation and gives next resident values whatever this mutation is fixed or not
}
\details{
This function gives the genotype (enzyme concentrations and activities) and phenotype (flux) values of the next resident in an haploid population after a time step.
Here, a time step corresponds to the apparition and fixation (or disappearance) of a mutation targeting one enzyme. 
Therefore a time step is the interval between appearances of two successive mutations.

This function is used for simulation of enzyme concentration evolution.

\bold{Algorithm}

\enumerate{
   \item target enzyme and mutation sign are chosen randomly with a uniform law
   \item mutation targets randomly concentration or kinetic parameter depending on \code{pmutA} value
   \item mutation size is chosen randomly between 0 and \code{max_mut_size_E} for concentrations (resp. \code{max_mut_size_A} for kinetic parameters), then multiplied by its sign
   \item mutation effects on all enzymes are computed with function \code{\link{mut.E.direct}} (resp. \code{\link{mut.kin}}). The input mutation method is only available for \code{\link{mut.E.old}}, but multiplicative mutation method \code{typ_E=2} is not accurate in case of regulation
   \item if concentration or kinetic parameter become negative, which is biologically impossible, they are set to 0
   \item activities, then flux are computed
   \item selection coefficient is also computed, considering flux as fitness
   \item fixation probability of this mutation is computed
   \item fixation of this mutation is random, depending on this fixation probability: if mutation is fixed, mutant become resident for next step, else resident is unchanged for next step
   \item returns value of the resident for next step
}
Algorithm is also detailed in Coton et al. (2021)
}
\examples{
E <- c(30,30,30)
kin <- c(53/0.29,50/0.78,29)
Keq <- c(1.1e+8,4.9e+3,1.1e+3)
beta <- matrix(c(1,10,5,0.1,1,0.5,0.2,2,1),nrow=3)
correl <- "RegPos"
N <- 1000

simul.next.resident(E, kin, Keq, N, correl, beta, pmutA=0.1)

}
\references{
Coton et al. (2021)
}
\seealso{
See function \code{\link{mut.E.direct}} and \code{\link{mut.kin}} to see how enzymes are mutated. 

Fitness is computed with function \code{\link{flux}}.
}
