% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/alpha_ij.R
\name{alpha_ij}
\alias{alpha_ij}
\title{Redistribution coefficient computation}
\usage{
alpha_ij(E_fun,correl_fun,beta_fun=NULL)
}
\arguments{
\item{E_fun}{Numeric vector of concentrations}

\item{correl_fun}{Character string indicating the abbreviation of the constraint applied on the system}

\item{beta_fun}{Matrix of co-regulation coefficients}
}
\value{
Square matrix of size \code{n} (where \code{n} is the length of \code{E_fun}, which is the number of enzymes) of the redistribution coefficients between all enzymes.
}
\description{
Computes the redistribution coefficients between all enzymes
}
\details{
The redistribution coefficients are influenced by the applied constraint.
    
For further details on how the redistribution coefficient is calculated, see Lion \emph{et al.} (2004).

For cases with co-regulations (i.e. \code{correl_fun} value is \code{"RegPos"}, \code{"RegNeg"}, \code{"CRPos"} or \code{"CRNeg"}), \code{beta_fun} is obligatory. In other cases (i.e. \code{correl_fun} value is \code{"SC"} or \code{"Comp"}), \code{beta_fun} is ignored, that is why default is \code{NULL}.

When \code{beta_fun} is obligatory, it has to be a square matrix of size \code{n}, where this number \code{n} is the length of \code{E_fun}.
}
\examples{
E <- c(30,30,30)
beta <- matrix(c(1,10,5,0.1,1,0.5,0.2,2,1),nrow=3)
correl <- "SC"

alph <- alpha_ij(E,correl,beta)


}
\references{
Lion, S., F. Gabriel, B. Bost, J. Fiévet, C. Dillmann, and D. De Vienne, 2004.
An extension to the metabolic control theory taking into account correlations between enzyme concentrations.
European Journal of Biochemistry 271:4375–4391.
}
\seealso{
See function \code{\link{is.correl.authorized}} to have more information about constraints and on the usage of argument \code{correl_fun}.
}
