% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/summary_functions.R
\name{RMSE}
\alias{RMSE}
\alias{RMSD}
\title{Compute the (normalized) root mean square error}
\usage{
RMSE(
  estimate,
  parameter = NULL,
  type = "RMSE",
  MSE = FALSE,
  percent = FALSE,
  unname = FALSE
)

RMSD(
  estimate,
  parameter = NULL,
  type = "RMSE",
  MSE = FALSE,
  percent = FALSE,
  unname = FALSE
)
}
\arguments{
\item{estimate}{a \code{numeric} vector, \code{matrix}/\code{data.frame}, or \code{list}
of parameter estimates.
If a vector, the length is equal to the number of replications. If a
\code{matrix}/\code{data.frame}, the number of rows must equal the number of replications.
\code{list} objects will be looped
over using the same rules after above after first translating the information into one-dimensional
vectors and re-creating the structure upon return}

\item{parameter}{a \code{numeric} scalar/vector indicating the fixed parameter values.
If a single value is supplied and \code{estimate} is a \code{matrix}/\code{data.frame} then
the value will be recycled for each column; otherwise, each element will be associated
with each respective column in the \code{estimate} input.
If \code{NULL} then it will be assumed that the \code{estimate} input is in a deviation
form (therefore \code{sqrt(mean(estimate^2))} will be returned)}

\item{type}{type of deviation to compute. Can be \code{'RMSE'} (default) for the root mean square-error,
\code{'NRMSE'} for the normalized RMSE (RMSE / (max(estimate) - min(estimate))),
\code{'SRMSE'} for the standardized RMSE (RMSE / sd(estimate)),
\code{'CV'} for the coefficient of variation, or \code{'RMSLE'} for the root mean-square log-error}

\item{MSE}{logical; return the mean square error equivalent of the results instead of the root
mean-square error (in other words, the result is squared)? Default is \code{FALSE}}

\item{percent}{logical; change returned result to percentage by multiplying by 100?
Default is FALSE}

\item{unname}{logical; apply \code{\link{unname}} to the results to remove any variable
names?}
}
\value{
returns a \code{numeric} vector indicating the overall average deviation in the estimates
}
\description{
Computes the average deviation (root mean square error; also known as the root mean square deviation)
of a sample estimate from the parameter value. Accepts estimate and parameter values,
as well as estimate values which are in deviation form.
}
\examples{

pop <- 1
samp <- rnorm(100, 1, sd = 0.5)
RMSE(samp, pop)

dev <- samp - pop
RMSE(dev)

RMSE(samp, pop, type = 'NRMSE')
RMSE(dev, type = 'NRMSE')
RMSE(dev, pop, type = 'SRMSE')
RMSE(samp, pop, type = 'CV')
RMSE(samp, pop, type = 'RMSLE')

# percentage reported
RMSE(samp, pop, type = 'NRMSE')
RMSE(samp, pop, type = 'NRMSE', percent = TRUE)

# matrix input
mat <- cbind(M1=rnorm(100, 2, sd = 0.5), M2 = rnorm(100, 2, sd = 1))
RMSE(mat, parameter = 2)
RMSE(mat, parameter = c(2, 3))

# different parameter associated with each column
mat <- cbind(M1=rnorm(1000, 2, sd = 0.25), M2 = rnorm(1000, 3, sd = .25))
RMSE(mat, parameter = c(2,3))

# same, but with data.frame
df <- data.frame(M1=rnorm(100, 2, sd = 0.5), M2 = rnorm(100, 2, sd = 1))
RMSE(df, parameter = c(2,2))

# parameters of the same size
parameters <- 1:10
estimates <- parameters + rnorm(10)
RMSE(estimates, parameters)

}
\references{
Chalmers, R. P., & Adkins, M. C.  (2020). Writing Effective and Reliable Monte Carlo Simulations
with the SimDesign Package. \code{The Quantitative Methods for Psychology, 16}(4), 248-280.
\doi{10.20982/tqmp.16.4.p248}

Sigal, M. J., & Chalmers, R. P. (2016). Play it again: Teaching statistics with Monte
Carlo simulation. \code{Journal of Statistics Education, 24}(3), 136-156.
\doi{10.1080/10691898.2016.1246953}
}
\seealso{
\code{\link{bias}}

MAE
}
\author{
Phil Chalmers \email{rphilip.chalmers@gmail.com}
}
