 [![](http://www.r-pkg.org/badges/version/SimDesign)](https://www.r-pkg.org:443/pkg/SimDesign) [![](http://cranlogs.r-pkg.org/badges/grand-total/SimDesign)](https://CRAN.R-project.org/package=SimDesign)


# SimDesign <img src="SimDesign-logo.png" align="right" height="200px" />

Structure for Organizing Monte Carlo Simulation Designs

## Installation

To install the latest stable version of the package from CRAN, please use the following in your R console:

```r
install.packages('SimDesign')
```

To install the Github version of the package with `devtools`, type the following (assuming you have already installed the `devtools` package from CRAN).

```r
library('devtools')
install_github('philchalmers/SimDesign')
```

## Getting started

For a discription pertaining to the philosophy and general workflow of the package it is helpful to first read through the following: [Chalmers, R. Philip, Adkins, Mark C. (2020) Writing Effective and Reliable Monte Carlo Simulations with the SimDesign Package, The Quantitative Methods for Psychology, 16(4), 248-280. doi: 10.20982/tqmp.16.4.p248](https://www.tqmp.org/RegularArticles/vol16-4/p248/index.html)

Coding examples found within this article range from relatively simple (e.g., a re-implementation of one of [Hallgren's (2013) simulation study examples](https://www.tqmp.org/RegularArticles/vol09-2/p043/index.html), as well as possible extensions to the simulation design) to more advanced real-world simulation experiments (e.g., [Flora and Curran's (2004) simulation study](https://psycnet.apa.org/doiLanding?doi=10.1037%2F1082-989X.9.4.466)). For additional information and instructions about how to use the package please refer to the examples in the associated [Github wiki](https://github.com/philchalmers/SimDesign/wiki).
