% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plotSimBIID_runs.R
\name{plot.SimBIID_runs}
\alias{plot.SimBIID_runs}
\title{Plots \code{SimBIID_runs} objects}
\usage{
\method{plot}{SimBIID_runs}(
  x,
  which = c("all", "t"),
  type = c("runs", "sums"),
  rep = NA,
  quant = 0.9,
  data = NULL,
  matchData = NULL,
  ...
)
}
\arguments{
\item{x}{An \code{SimBIID_runs} object.}

\item{which}{A character vector of states to plot. Can be \code{"all"} to plot all
states (and final event times), or \code{"t"} to plot final event times.}

\item{type}{Character stating whether to plot full simulations over time (\code{"runs"}) or
summaries (\code{"sums"}).}

\item{rep}{An integer vector of simulation runs to plot.}

\item{quant}{A vector of quantiles (> 0.5) to plot if \code{type == "runs"}.}

\item{data}{A \code{data.frame} containing time series count data, 
with the first column called \code{t}, followed by columns of time-series counts.}

\item{matchData}{A character vector containing matches between the columns of \code{data} and
the columns of the model runs. Each entry must be of the form e.g. \code{"SD = SR"},
where \code{SD} is the name of the column in \code{data}, and \code{SR} is the name
of the column in \code{x}.}

\item{...}{Not used here.}
}
\value{
A plot of individual simulations and/or summaries of repeated simulations 
        extracted from \code{SimBIID_runs} object.
}
\description{
Plot method for \code{SimBIID_runs} objects.
}
\examples{
\donttest{
## set up SIR simulation model
transitions <- c(
    "S -> beta * S * I -> I", 
    "I -> gamma * I -> R"
)
compartments <- c("S", "I", "R")
pars <- c("beta", "gamma")
model <- mparseRcpp(
    transitions = transitions, 
    compartments = compartments,
    pars = pars,
    tspan = TRUE
)

## run 100 replicate simulations and
## plot outputs
sims <- run(
    model = model,
    pars = c(beta = 0.001, gamma = 0.1),
    tstart = 0,
    tstop = 100,
    u = c(S = 119, I = 1, R = 0),
    tspan = seq(1, 100, length.out = 10),
    nrep = 100
)
plot(sims, quant = c(0.55, 0.75, 0.9))

## add replicate 1 to plot
plot(sims, quant = c(0.55, 0.75, 0.9), rep = 1)
}

}
\seealso{
\code{\link{mparseRcpp}}, \code{\link{print.SimBIID_runs}}, \code{\link{run}}
}
