% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fragments.R
\name{FilterCells}
\alias{FilterCells}
\title{Filter cells from fragment file}
\usage{
FilterCells(
  fragments,
  cells,
  outfile = NULL,
  buffer_length = 256L,
  verbose = TRUE
)
}
\arguments{
\item{fragments}{Path to a fragment file}

\item{cells}{A vector of cells to keep}

\item{outfile}{Name for output file}

\item{buffer_length}{Size of buffer to be read from the fragment file. This
must be longer than the longest line in the file.}

\item{verbose}{Display messages}
}
\description{
Remove all fragments that are not from an allowed set of cell barcodes from
the fragment file. This will create a new file on disk that only contains
fragments from cells specified in the \code{cells} argument. The output file
is block gzip-compressed and indexed, ready for use with Signac functions.
}
\examples{
fpath <- system.file("extdata", "fragments.tsv.gz", package="Signac")
tmpf <- tempfile(fileext = ".gz")
FilterCells(
  fragments = fpath,
  cells = head(colnames(atac_small)),
  outfile = tmpf
)
file.remove(tmpf)
}
\concept{fragments}
