% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/preprocessing.R
\name{GenomeBinMatrix}
\alias{GenomeBinMatrix}
\title{GenomeBinMatrix}
\usage{
GenomeBinMatrix(
  fragments,
  genome,
  cells = NULL,
  binsize = 5000,
  chunk = 50,
  sep = c("-", "-"),
  verbose = TRUE
)
}
\arguments{
\item{fragments}{Path to tabix-indexed fragments file}

\item{genome}{A vector of chromosome sizes for the genome. This is used to
construct the genome bin coordinates. The can be obtained by calling
\code{\link[GenomeInfoDb]{seqlengths}} on a
\code{\link[BSgenome]{BSgenome-class}} object.}

\item{cells}{Vector of cells to include. If NULL, include all cells found
in the fragments file}

\item{binsize}{Size of the genome bins to use}

\item{chunk}{Number of chunks to use when processing the fragments file.
Fewer chunks may enable faster processing, but will use more memory.}

\item{sep}{Vector of separators to use for genomic string. First element is
used to separate chromosome and coordinates, second separator is used to
separate start and end coordinates.}

\item{verbose}{Display messages}
}
\value{
Returns a sparse matrix
}
\description{
Construct a bin x cell matrix from a fragments file.
}
\details{
This function bins the genome and calls \code{\link{FeatureMatrix}} to
construct a bin x cell matrix.
}
\examples{
gn <- 780007
names(gn) <- 'chr1'
fpath <- system.file("extdata", "fragments.tsv.gz", package="Signac")
GenomeBinMatrix(
  fragments = fpath,
  genome = gn,
  binsize = 1000,
  chunk = 1
)
}
