% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utilities.R
\name{MergeWithRegions}
\alias{MergeWithRegions}
\title{Region-aware object merging}
\usage{
MergeWithRegions(
  object.1,
  object.2,
  assay.1 = NULL,
  assay.2 = NULL,
  sep.1 = c("-", "-"),
  sep.2 = c("-", "-"),
  regions.use = 1,
  distance = 0,
  new.assay.name = "peaks",
  project = "SeuratProject",
  verbose = TRUE,
  ...
)
}
\arguments{
\item{object.1}{The first Seurat object}

\item{object.2}{The second Seurat object}

\item{assay.1}{Name of the assay to use in the first object. If NULL, use
the default assay}

\item{assay.2}{Name of the assay to use in the second object. If NULL, use
the default assay}

\item{sep.1}{Genomic coordinate separators to use for the first object}

\item{sep.2}{Genomic coordinate separators to use for the second object}

\item{regions.use}{Which regions to use when naming regions in the merged object.
Options are:
\itemize{
 \item{1}: Use the region coordinates from the first object
 \item{2}: Use the region coordinates from the second object
}}

\item{distance}{Maximum distance between regions allowed for an intersection to
be recorded. Default is 0.}

\item{new.assay.name}{Name for the merged assay. Default is 'peaks'}

\item{project}{Project name for the new object}

\item{verbose}{Display messages}

\item{...}{Additional arguments passed to \code{\link[Seurat]{CreateAssayObject}}}
}
\value{
Returns a \code{\link[Seurat]{Seurat}} object
}
\description{
This will find intersecting regions in both objects and rename the
overlapping features with the region coordinates of the first object
(by default; this can be changed with the regions.use parameter).
}
\details{
This allows a merged object to be constructed with common feature names.
}
\examples{
MergeWithRegions(
  object.1 = atac_small,
  object.2 = atac_small,
  assay.1 = 'peaks',
  assay.2 = 'bins',
  sep.1 = c(":","-"),
  sep.2 = c("-","-")
)
}
