% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gen_zinb.R
\name{qzinb}
\alias{qzinb}
\title{The Zero-Inflated Negative Binomial Distribution}
\usage{
qzinb(p, size, mu, rho, lower.tail = TRUE, log.p = FALSE)
}
\arguments{
\item{p}{A vector of probabilities}

\item{size}{The dispersion paramater used in \code{\link[stats:NegBinomial]{dnbinom}}}

\item{mu}{The mean parameter used in \code{\link[stats:NegBinomial]{dnbinom}}.}

\item{rho}{The zero-inflation parameter.}

\item{lower.tail}{Logical; if \code{TRUE}, then probabilities are P(X <= x).
Otherwise, P(X > x).}

\item{log.p}{Logical; if \code{TRUE}, then exp(p) is used.}
}
\value{
The quantiles for the given probabilities.
}
\description{
The Zero-Inflated Negative Binomial Distribution
}
\examples{
x <- rzinb(10, 1, 10, 0.1)
p <- pzinb(x, 1, 10, 0.1)
y <- qzinb(p, 1, 10, 0.1)
all(x == y)
# Compute P(0 < X < 5) for X ~ ZINB(1, 10, 0.1)
sum(dzinb(0:5, 1, 10, 0.1))
}
