% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gen_zinb.R
\name{rzinb}
\alias{rzinb}
\title{The Zero-Inflated Negative Binomial Distribution}
\usage{
rzinb(n, size, mu, rho)
}
\arguments{
\item{n}{The number of random values to return.}

\item{size}{The dispersion paramater used in dnbinom.}

\item{mu}{The distribution mean.}

\item{rho}{The zero-inflation parameter.}
}
\description{
The Zero-Inflated Negative Binomial Distribution
}
\examples{
x <- rzinb(10, 1, 10, 0.1)
p <- pzinb(x, 1, 10, 0.1)
y <- qzinb(p, 1, 10, 0.1)
all(x == y)
# Compute P(0 < X < 5) for X ~ ZINB(1, 10, 0.1)
sum(dzinb(0:5, 1, 10, 0.1))
}
