% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plotting.R
\name{plot_network_diff}
\alias{plot_network_diff}
\title{Plot the difference between two networks}
\usage{
plot_network_diff(network_1, network_2, compare_graph = NULL,
  as_subgraph = FALSE, node_scale = 4, edge_scale = 1,
  node_color = adjustcolor("orange", 0.5), edge_colors = c("black",
  "wheat", "red"), generate_layout = igraph::nicely,
  include_vertex_labels = TRUE, ...)
}
\arguments{
\item{network_1}{A 'network' or 'matrix' object.}

\item{network_2}{A 'network' or 'matrix' object.}

\item{compare_graph}{The plot of another network to use for comparison.}

\item{as_subgraph}{If TRUE, only nodes of positive degree will be shown.}

\item{node_scale}{Used for scaling of nodes.}

\item{edge_scale}{Used for scaling of edges.}

\item{node_color}{The color used for the nodes.}

\item{edge_colors}{A vector of three colors used for edges; the first colors
edges common to both network, the second colors edges in network_1 but not
network_2, and the third colors edges that are in network_2 but not 
network_1. Default is c("black", "wheat", "red").}

\item{generate_layout}{A function to generate the layout of a graph; used
if coords is NULL. See ?igraph::layout_ for details. Other options include 
'igraph::as_star', 'igraph::in_circle', and 'igraph::with_fr', among many others.}

\item{include_vertex_labels}{If TRUE, the verticies will be labeled.}

\item{...}{Additional arguments passed to plot.igraph().}
}
\value{
Creates a plot of the network and returns a graph object. 
The graph object can be passed back into a future call of 'plot_network()',
'plot_network_diff()' or 'plot_network_sim()'
through the 'compare_edge' argument, which will setup the plot for easier 
comparison between the old graph and the graph of 'network'.
}
\description{
This function plots the difference in connectivity between two networks. 
For two identical networks, the graph will be empty. For non-identical 
networks, black edges are shared by both networks but differ in magnitude or 
direction (if the networks are weighted), tan edges are in network_1 but not 
network_2, and red edges are in network_2 but not network_1. All edges are
scaled according to the strongest association in either network.
}
\examples{
# Create two networks, the second being a perturbation of the first.
nw1 <- random_network(20)
nw2 <- perturb_network(nw1, n_nodes = 5)
# Can compare networks by plotting each using the same layout.
g <- plot(nw1)
plot(nw2, g)
# Or, the differential network can be plotted.
plot_network_diff(nw1, nw2, g)
}
