% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/equate.multi.R
\name{equate.multi}
\alias{equate.multi}
\title{Equate Multiple Groups}
\usage{
equate.multi(...)
}
\arguments{
\item{...}{Matrices or data frames.
Binary response matrices to be equated}
}
\value{
This function returns a list containing the
equated binary response matrices in the order they were input.
The response matrices are labeled as the object name they were
entered with
}
\description{
A function to apply \code{\link[SemNetCleaner]{equate}}
to multiple response matrices
}
\examples{
# Toy example
raw <- open.animals[c(1:10),-c(1,2)]

# Clean and prepocess data
clean <- textcleaner(raw, partBY = "row", dictionary = "animals")

# Obtain binary data
bin <- clean$binary

# Finalize mat1
mat1 <- finalize(bin[c(1:5),])

# Finalize mat2
mat2 <- finalize(bin[c(6:10),])


# Equate mat1 and mat1
eq <- equate.multi(mat1, mat2)

# Obtain respective equated response matrices
eq.mat1 <- eq$mat1
eq.mat2 <- eq$mat2

}
\author{
Alexander Christensen <alexpaulchristensen@gmail.com>
}
