% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/boost.R
\name{boost}
\alias{boost}
\alias{boost.normalize}
\alias{boost.compcorrs}
\alias{boost.correlation_sign}
\alias{boost.findgroups}
\alias{boost.Xpass}
\alias{boost.adjust}
\alias{boost.random}
\alias{boost.apply}
\alias{boost.select}
\title{Boost step by step functions}
\usage{
boost.normalize(X, eps = 1e-08)

boost.compcorrs(Xnorm, corrfunc = "cor", verbose = FALSE,
  testvarindic = rep(TRUE, ncol(Xnorm)))

boost.correlation_sign(Correlation_matrice, verbose = FALSE)

boost.findgroups(Correlation_matrice, group, corr = 1, verbose = FALSE)

boost.Xpass(nrowX, ncolX)

boost.adjust(X, groups, Correlation_sign, Xpass = boost.Xpass(nrowX,
  ncolX), verbose = FALSE, use.parallel = FALSE, ncores = 4)

boost.random(X, Xpass, vmf.params, verbose = FALSE, B = 100,
  use.parallel = FALSE, ncores = 4)

boost.apply(X, cols.simul, Y, func, verbose = FALSE,
  use.parallel = FALSE, ncores = 4, ...)

boost.select(Boost.coeffs, eps = 10^(-4), version = "lars",
  verbose = FALSE)
}
\arguments{
\item{X}{Numerical matrix. Matrix of the variables.}

\item{eps}{Numerical value. Response vector.}

\item{Xnorm}{Numerical matrix. Needs to be centered and l2 normalized.}

\item{corrfunc}{Character value or function. The function to compute associations between the variables.}

\item{verbose}{Boolean.
Defaults to \code{FALSE}.}

\item{testvarindic}{Boolean vector. Compute associations for a subset of variables.
By default, the scope of the computation is the whole dataset, i.e. \code{rep(TRUE,ncol(Xnorm))}.}

\item{Correlation_matrice}{Numerical matrix.}

\item{group}{Character value or function. The grouping function.}

\item{corr}{Numerical value. Thresholding value. Defaults to \code{1}.}

\item{nrowX}{Numerical value}

\item{ncolX}{Numerical value.}

\item{groups}{List. List of groups or communities (compact form).}

\item{Correlation_sign}{Numerical -1/1 matrix.}

\item{Xpass}{Numerical value. Transformation matrix.
Defaults to \code{boost.Xpass(nrowX,ncolX)}, with \code{nrowX=nrow(X)} and \code{ncolX=ncol(X)}.}

\item{use.parallel}{Boolean.
Defaults to \code{FALSE}.}

\item{ncores}{Numerical value. Number of cores to use.
Defaults to \code{4}.}

\item{vmf.params}{List. List of the parameters ot the fitted von-Mises distributions.}

\item{B}{Integer value. Number of resampling.}

\item{cols.simul}{Numerical value. Transformation matrix.}

\item{Y}{Numerical vector or factor. Response.}

\item{func}{Function. Variable selection function.}

\item{...}{. Additionnal parameters passed to the \code{func} function.}

\item{Boost.coeffs}{Numerical matrix. l2 normed matrix of predictors.}

\item{version}{Character value. "lars" (no intercept value) or "glmnet" (first coefficient is the intercept value).}
}
\value{
Various types depending on the function.
}
\description{
Step by step functions to apply the selectboost algorithm.
}
\details{
\code{boost.normalize} returns a numeric matrix whose colun are centered and l2 normalized.

\code{boost.compcorrs} returns a correlation like matrix computed using the \code{corrfunc} function.

\code{boost.Xpass} returns the transformation matrix.

\code{boost.findgroups} returns a list of groups or communities found using the \code{group} function.

\code{boost.Xpass} returns the transformation matrix.

\code{boost.adjust} returns the list of the parameters ot the fitted von-Mises distributions.

\code{boost.random} returns an array with the resampled datasets.

\code{boost.apply} returns a matrix with the coefficients estimated using the resampled datasets.

\code{boost.select} returns a vector with the proportion of times each variable was selected.
}
\examples{
set.seed(314)
xran=matrix(rnorm(200),20,10)
yran=rnorm(20)
xran_norm <- boost.normalize(xran)

xran_corr<- boost.compcorrs(xran_norm)

xran_corr_sign <- boost.correlation_sign(xran_corr)

xran_groups <- boost.findgroups(xran_corr, group=group_func_1, .3)
xran_groups_2 <- boost.findgroups(xran_corr, group=group_func_2, .3)

xran_Xpass <- boost.Xpass(nrow(xran_norm),ncol(xran_norm))

xran_adjust <- boost.adjust(xran_norm, xran_groups$groups, xran_corr_sign)

#Not meaningful, should be run with B>=100
xran_random <- boost.random(xran_norm, xran_Xpass, xran_adjust$vmf.params, B=5)

\donttest{
xran_random <- boost.random(xran_norm, xran_Xpass, xran_adjust$vmf.params, B=100)
}

xran_apply <- boost.apply(xran_norm, xran_random, yran, lasso_msgps_AICc)

xran_select <- boost.select(xran_apply)

}
\references{
\emph{selectBoost: a general algorithm to enhance the performance of variable selection methods in correlated datasets}, Ismaïl Aouadi, Nicolas Jung, Raphael Carapito, Laurent Vallat, Seiamak Bahram, Myriam Maumy-Bertrand, Frédéric Bertrand, \url{https://arxiv.org/abs/1810.01670}
}
\seealso{
\code{\link{fastboost}}, \code{\link{autoboost}}

Other Selectboost functions: \code{\link{autoboost}},
  \code{\link{fastboost}},
  \code{\link{plot_selectboost_cascade}},
  \code{\link{selectboost_cascade}}
}
\author{
Frederic Bertrand, \email{frederic.bertrand@math.unistra.fr}
}
\concept{Selectboost functions}
