\name{evalSolution}
\Rdversion{1.1}
\alias{evalSolution}
\title{
Allows to evaluate the solution produced by the function 'optimizeStrata' by
selecting a number of samples from the frame with the optimal stratification, and
calculating average CV's on the target variables Y's together with differences
between estimates and the values of the parameters in the population.
}
\description{
The user can indicate the number of samples that must be selected by the frame to which 
the optimal stratification has been applied. The allocation is the one reported in the
dataframe 'outstrata'. First, the true values of the parameters are calculated from the
frame. Then, for each sample the sampling estimates are calculated, together with the 
differences between them and the true values of the parameters.
At the end, an estimate of the CV is produced for each target variable, in order to compare them
with the precision constraints set at the beginning of the optimization process.
If the flag 'writeFiles' is set to TRUE, boxplots of distribution of the CV's in the different 
domains are produced for each Y variable ('cv.pdf'),
together with boxplot of the distributions of differences between estimates and values of the parameters
in the population ('differences.pdf').

}
\usage{
evalSolution(frame,
		outstrata,
		nsampl=100,
		writeFiles=FALSE)
}
\arguments{
  \item{frame}{
The frame to which the optimal stratification has been applied ('framenew')
	}
  \item{outstrata}{
The new (aggregated) strata generated by the function 'optimizeStrata'
	}
  \item{nsampl}{
The number of sample to be drawn from the frame
	}
  \item{writeFiles}{
A flag to write in the work directory the outputs of the function
	}
}
\value{
A list containing (1) the vector of the solution and (2) the optimal aggregated strata
}

\author{
Giulio Barcaroli
}

\examples{
\dontrun{
library(SamplingStrata)
data(swisserrors)
data(swissstrata)
solution <- optimizeStrata (
	errors = swisserrors,
	strata = swissstrata,
	cens = NULL,
	strcens = FALSE,
	alldomains = TRUE,
	dom = dominio,
	initialStrata = nrow(swissstrata)/3,
	addStrataFactor = 0.01,
	minnumstr = 2,
	iter = 50,
	pops = 20,
	mut_chance = 0.05,
	elitism_rate = 0.2,
	highvalue = 100000000,
	suggestions = NULL,
	realAllocation = TRUE,
	writeFiles = FALSE)
# update sampling strata with new strata labels
#swissstrata <- swissstrata[swissstrata$DOM1 == dominio,]
newstrata <- updateStrata(swissstrata, solution, writeFiles = TRUE)
# update sampling frame with new strata labels
data(swissframe)
framenew <- updateFrame(frame=swissframe,newstrata=newstrata,writeFile=TRUE)
samp <- selectSample(framenew,solution$aggr_strata,writeFiles=TRUE)
# evaluate the current solution
results <- evalSolution(framenew, solution$aggr_strata, 100, writeFiles = TRUE)
boxplot(val ~ cv, data = results$coeff_var,
        col = "orange",
        main = "Distribution of CV's in the domains",
        xlab = "Variables Y",
        ylab = "Value of CV")
diff <- read.csv("differences.csv")
numY <- sum(grepl("diff", colnames(diff)))
k <- ceiling(numY/4)
for (j in 1:k) {
    split.screen(c(2, 2))
    for (i in 1:4) {
        if (i + 4 * (j - 1) <= numY) {
            stmt <- paste("screen(", i, ")", sep = "")
            eval(parse(text = stmt))
    	stmt <- paste("boxplot(diff",i,"~dom,
                    data=diff,ylab='Differences',
                    xlab='Domain',col = 'orange')",sep="")
			eval(parse(text = stmt))
            stmt <- paste("mtext(expression(Y", i , "), side=3, adj=0, cex=1.0, line=1)", 
                  sep = "")
            eval(parse(text = stmt))
        }
    }
}
}
}
\keyword{ survey }