% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/simPop.R
\name{aggPixelPreds}
\alias{aggPixelPreds}
\title{Helper function of \code{\link{pixelPopToArea}}}
\usage{
aggPixelPreds(
  Zg,
  Ng,
  areas,
  urban = targetPopMat$urban,
  targetPopMat = NULL,
  useDensity = FALSE,
  stratifyByUrban = TRUE,
  normalize = useDensity
)
}
\arguments{
\item{Zg}{nIntegrationPoint x nsim matrix of simulated response (population numerators) for each pixel and sample}

\item{Ng}{nIntegrationPoint x nsim matrix of simulated counts (population denominators) for each pixel and sample}

\item{areas}{nIntegrationPoint length character vector of areas (or subareas)}

\item{urban}{nIntegrationPoint length vector of indicators specifying whether or not pixels are urban or rural}

\item{targetPopMat}{same as in \code{\link{simPopCustom}}}

\item{useDensity}{whether to use population density as aggregation weights.}

\item{stratifyByUrban}{whether or not to stratify simulations by urban/rural classification}

\item{normalize}{if TRUE, pixel level aggregation weights within specified area are normalized to sum to 1. This produces an 
average of the values in Zg rather than a sum. In general, should only be set to TRUE for smooth integrals of risk.}
}
\description{
Aggregates population from the 
pixel level to the level of the area of interest.
}
