% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fitspace.R
\name{fitGeneric}
\alias{fitGeneric}
\title{Fit space-time smoothing models for a generic outcome from complex surveys.}
\usage{
fitGeneric(data, geo, Amat, X = NULL, responseType = c("binary",
  "gaussian")[1], responseVar, strataVar = "strata",
  weightVar = "weights", regionVar = "region",
  clusterVar = "~v001+v002", pc.u = 1, pc.alpha = 0.01,
  pc.u.phi = 0.5, pc.alpha.phi = 2/3, CI = 0.95, FUN = NULL,
  formula = NULL, timeVar = NULL, time.model = c("rw1", "rw2")[1],
  type.st = 1)
}
\arguments{
\item{data}{data frame with region and strata information.}

\item{geo}{Geo file}

\item{Amat}{Adjacency matrix for the regions}

\item{X}{Covariate matrix with the first column being the region names. Currently only supporting static region-level covariates.}

\item{responseType}{Type of the response variable, currently supports 'binary' (default with logit link function) or 'gaussian'.}

\item{responseVar}{the response variable}

\item{strataVar}{the strata variable}

\item{weightVar}{the weights variable}

\item{regionVar}{Variable name for region, typically 'v024', for older surveys might be 'v101'}

\item{clusterVar}{Variable name for cluster, typically '~v001 + v002'}

\item{pc.u}{hyperparameter U for the PC prior on precisions.}

\item{pc.alpha}{hyperparameter alpha for the PC prior on precisions.}

\item{pc.u.phi}{hyperparameter U for the PC prior on the mixture probability phi in BYM2 model.}

\item{pc.alpha.phi}{hyperparameter alpha for the PC prior on the mixture probability phi in BYM2 model.}

\item{CI}{the desired posterior credible interval to calculate}

\item{FUN}{the function to transform the posterior draws. Default to be identify function for normal variable and inverse logit transformation for binomial variables}

\item{formula}{a string of user-specified random effects model to be used in the INLA call}

\item{timeVar}{The variable indicating time period. If set to NULL then the temporal model and space-time interaction model are ignored.}

\item{time.model}{the model for temporal trends and interactions. It can be either "rw1" or "rw2".}

\item{type.st}{can take values 0 (no interaction), or 1 to 4, corresponding to the type I to IV space-time interaction.}
}
\value{
\item{HT}{Direct estimates}
\item{smooth}{Spatially smoothed estimates}
\item{fit}{a fitted INLA object}
\item{geo}{input argument}
\item{Amat}{input argument}
\item{CI}{input argument}
\item{responseType}{input argument}
\item{FUN}{input argument}
}
\description{
This function calculates the direct estimates by region and fit a simple spatial smoothing model to the direct estimates adjusting for survey design.
}
\details{
Normal or binary variables are currently supported. For binary variables, the logit transformation is performed on the direct estimates of probabilities, and a Gaussian additive model is fitted on the logit scale using INLA.
}
\examples{
\dontrun{
data(DemoData2)
data(DemoMap2)
fit <- fitGeneric(data=DemoData2, geo=DemoMap2$geo, 
Amat=DemoMap2$Amat, responseType="binary", 
responseVar="tobacco.use", strataVar="strata", 
weightVar="weights", regionVar="region", 
clusterVar = "~clustid+id", CI = 0.95)

# Example with region-level covariates
 Xmat <- aggregate(age~region, data = DemoData2, FUN = mean)
 fit <- fitGeneric(data=DemoData2, geo=DemoMap2$geo, 
  Amat=DemoMap2$Amat, responseType="binary", 
  X = Xmat,
  responseVar="tobacco.use", strataVar="strata", 
  weightVar="weights", regionVar="region", 
  clusterVar = "~clustid+id", CI = 0.95)
}
}
\seealso{
\code{\link{getDirectList}}, \code{\link{fitINLA}}
}
