% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/visualization.R
\name{displayPlotSeries}
\alias{displayPlotSeries}
\title{Plot spatial series by selected columns}
\usage{
displayPlotSeries(dataset, rankList, position, space)
}
\arguments{
\item{dataset}{Dataset containing numeric values}

\item{rankList}{List of ranked motifs}

\item{position}{Select by an integer a motif with his position}

\item{space}{Select a range of columns to plot the corresponding spatial series}
}
\value{
Plot the spatial series
}
\description{
Plot a selected motif and range of columns of the dataset
}
\examples{
#Launch all the workflow
candidates <- STSIdentifyCandidateSTMotifs(STMotif::example_dataset, 10, 10, 7, 3)
stmotifs <- STSIdentifySTMotifs(candidates, 1, 1)
sttightmotifs <- STSIdentifyTightSTMotifs(stmotifs, candidates$rectangles)
rankResult <- STSRankTightSTMotifs(sttightmotifs)

#Plot the result
displayPlotSeries(dataset = STMotif::example_dataset, rankResult, 1, 2:11)
}
