% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/qaqc_stic_data.R
\name{qaqc_stic_data}
\alias{qaqc_stic_data}
\title{qaqc_stic_data}
\usage{
qaqc_stic_data(
  stic_data,
  spc_neg_correction = TRUE,
  inspect_deviation = TRUE,
  deviation_size = NULL,
  window_size = NULL
)
}
\arguments{
\item{stic_data}{A data frame with classified STIC data, such as that produced by \code{classify_wetdry}.}

\item{spc_neg_correction}{a logical argument indicating whether the user would like to correct negative SPC values resulting from the calibration process to 0.
The character code associated with this correction is \code{"C"}.}

\item{inspect_deviation}{a logical argument indicating whether the user would like to identify deviation anomalies, in which a series of wet or dry readings less than or equal to `deviation_size` in length is surrounded on both sides by `window_size` or more observations of its opposite.
This operation is meant to identify potentially suspect binary wet/dry data points for further examination.
The character code associated with this operation is \code{"D"}.}

\item{deviation_size}{a numeric argument specifying the maximum size (i.e., number of observations) of a clustered group of points that can be flagged as an deviation}

\item{window_size}{a numeric argument specifying the minimum size (i.e., number of observations) that the deviation must be surrounded by in order to be flagged}
}
\value{
The same data frame as input, but with new QAQC columns or a single, concatenated QAQC column. The QAQC output
Can include: \code{"C"}, meaning the calibrated SpC value was negative from `spc_neg_correction`; \code{"D"}, meaning the point was identified as
a deviation or deviation based on a moving window from `inspect_deviation`; or \code{"O"}, meaning the calibrated SpC was
outside the standard range based on the function \code{apply_calibration}.
}
\description{
This function provides multiple options for QAQC flagging of processed and classified STIC data frames, such as those generated by the \link{classify_wetdry} function.
Users can select which operations are to be performed, and a single new QAQC column is created with all flags concatenated. QAQC options currently include: (1) correction and flagging of negative SPC values resulting from the calibration process, i.e., changing the negative values to 0 and flagging this
(2) inspecting the wetdry classification time series for potential deviation anomalies based on user-defined windows
}
\examples{
qaqc_df <-
  qaqc_stic_data(classified_df,
    spc_neg_correction = TRUE,
    inspect_deviation = TRUE,
    deviation_size = 4, window_size = 96
  )
head(qaqc_df)
}
