% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/summary_ssp.R
\name{summary_ssp}
\alias{summary_ssp}
\title{Summary of MultSE for Each Sampling Effort in Simulated Data Sets}
\usage{
summary_ssp(results, multi.site)
}
\arguments{
\item{results}{A matrix generated by \code{\link{sampsd}} containing MultSE values for each simulation and sampling configuration.}

\item{multi.site}{Logical. Indicates whether multiple sites were simulated.}
}
\value{
A data frame summarizing MultSE for each sampling effort, including the mean, quantiles, relativized values, and estimated derivative.
}
\description{
Computes the average MultSE (pseudo-multivariate standard error) for each sampling effort across simulated datasets,
and estimates associated variation and rate of change.
}
\details{
For each sampling effort in each simulated data set, the average MultSE is computed (Anderson & Santana-Garcon, 2015).
The function then calculates the overall mean and associated lower and upper quantiles of these averages.
To evaluate how precision improves with effort, the average MultSE values are relativized to the maximum (typically at the lowest effort),
and a numerical forward finite difference derivative is calculated to approximate the rate of change.

This output is used to support the identification of optimal and redundant sampling efforts based on precision gain.
}
\note{
This data frame can be used to plot MultSE versus sampling effort and to apply cutoff rules using \code{\link{ioptimum}}.
}
\examples{
## Single site example
data(micromollusk)
par.mic <- assempar(data = micromollusk, type = "P/A", Sest.method = "average")
sim.mic <- simdata(par.mic, cases = 3, N = 10, sites = 1)
sam.mic <- sampsd(dat.sim = sim.mic, Par = par.mic, transformation = "P/A",
                  method = "jaccard", n = 10, m = 1, k = 3)
summ.mic <- summary_ssp(results = sam.mic, multi.site = FALSE)

## Multiple site example
data(sponges)
par.spo <- assempar(data = sponges, type = "counts", Sest.method = "average")
sim.spo <- simdata(par.spo, cases = 3, N = 20, sites = 3)
sam.spo <- sampsd(dat.sim = sim.spo, Par = par.spo, transformation = "square root",
                  method = "bray", n = 10, m = 3, k = 3)
summ.spo <- summary_ssp(results = sam.spo, multi.site = TRUE)

}
\references{
Anderson, M. J., & Santana-Garcon, J. (2015). Measures of precision for dissimilarity-based multivariate analysis of ecological communities. Ecology Letters, 18(1), 66–73.

Guerra-Castro, E.J., Cajas, J.C., Simões, N., Cruz-Motta, J.J., & Mascaró, M. (2021). SSP: an R package to estimate sampling effort in studies of ecological communities. Ecography 44(4), 561-573. doi: \doi{10.1111/ecog.05284}
}
\seealso{
\code{\link{sampsd}}, \code{\link{ioptimum}}
}
