% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/loocv.R, R/loocv_glm.R
\name{loocv.SSN2}
\alias{loocv.SSN2}
\alias{loocv.ssn_lm}
\alias{loocv.ssn_glm}
\title{Perform leave-one-out cross validation}
\usage{
\method{loocv}{ssn_lm}(object, cv_predict = FALSE, se.fit = FALSE, ...)

\method{loocv}{ssn_glm}(
  object,
  cv_predict = FALSE,
  type = c("link", "response"),
  se.fit = FALSE,
  ...
)
}
\arguments{
\item{object}{A fitted model object from \code{\link[=ssn_lm]{ssn_lm()}} or \code{\link[=ssn_glm]{ssn_glm()}}.}

\item{cv_predict}{A logical indicating whether the leave-one-out fitted values
should be returned. Defaults to \code{FALSE}.}

\item{se.fit}{A logical indicating whether the leave-one-out
prediction standard errors should be returned. Defaults to \code{FALSE}.}

\item{...}{Other arguments. Not used (needed for generic consistency).}

\item{type}{The scale (\code{response} or \code{link}) of predictions obtained
when \code{cv_predict = TRUE} and using \code{ssn_glm()} objects.}
}
\value{
If \code{cv_predict = FALSE} and \code{se.fit = FALSE},
a tibble indicating several
leave-one-out cross validation error metrics. If \code{cv_predict = TRUE} or \code{se.fit = TRUE},
a list with elements: \code{stats}, a tibble indicating several
leave-one-out cross validation metrics; \code{cv_predict}, a numeric vector
with leave-one-out predictions for each observation (if \code{cv_predict = TRUE});
and \code{se.fit}, a numeric vector with leave-one-out prediction standard
errors for each observation (if \code{se.fit = TRUE}).

If an \code{ssn_lm} object, the cross validation error metrics are:
\itemize{
\item bias: The average difference between the predicted value and true value
\item std.bias: The average standardized difference between the predicted value and true value
\item MSPE: The average squared difference between the predicted value and true value
\item RMSPE: The root average squared difference between the predicted value and true value
\item std.MSPE: The average standardized squared difference between the predicted value and true value
\item RAV: The root of the average estimated variance of the predicted value
\item cor2: The squared correlation between the predicted and true values
\item cover.80: Coverage rates of 80\% prediction intervals built for the true values
\item cover.90: Coverage rates of 90\% prediction intervals built for the true values
\item cover.95: Coverage rates of 95\% prediction intervals built for the true values
}

If an \code{ssn_glm} object, the cross validation error metrics are:
\itemize{
\item bias: The average difference between the predicted value and true value
\item MSPE: The average squared difference between the predicted value and true value
\item RMSPE: The root average squared difference between the predicted value and true value
\item RAV: The root of the average estimated variance of the predicted value (on the link scale)
}
}
\description{
Perform leave-one-out cross validation.
}
\details{
Each observation is held-out from the data set and the remaining data
are used to make a prediction for the held-out observation. This is compared
to the true value of the observation and several model-fit statistics are computed
across all observations. Currently only computationally feasible for observed data
matrices smaller than approximately 10,000.
}
\examples{
# Copy the mf04p .ssn data to a local directory and read it into R
# When modeling with your .ssn object, you will load it using the relevant
# path to the .ssn data on your machine
copy_lsn_to_temp()
temp_path <- paste0(tempdir(), "/MiddleFork04.ssn")
mf04p <- ssn_import(temp_path, overwrite = TRUE)

ssn_mod <- ssn_lm(
  formula = Summer_mn ~ ELEV_DEM,
  ssn.object = mf04p,
  tailup_type = "exponential",
  additive = "afvArea"
)
loocv(ssn_mod)
}
