% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/FindDisclosiveCells.R
\name{FindDisclosiveCells}
\alias{FindDisclosiveCells}
\title{Find directly disclosive cells}
\usage{
FindDisclosiveCells(
  data,
  freq,
  crossTable,
  primaryDims = names(crossTable),
  unknowns = rep(NA, length(primaryDims)),
  total = rep("Total", length(primaryDims)),
  unknown.threshold = 0,
  coalition = 1,
  suppressSmallCells = FALSE,
  ...
)
}
\arguments{
\item{data}{the data set}

\item{freq}{vector containing frequencies}

\item{crossTable}{cross table of key variables produced by ModelMatrix
in parent function}

\item{primaryDims}{dimensions to be considered for direct disclosure.}

\item{unknowns}{vector of unknown values for each of the primary dimensions.
If a primary dimension does not contain unknown values, NA should be passed.}

\item{total}{string name for marginal values}

\item{unknown.threshold}{numeric for specifying a percentage for calculating
safety of cells. A cell is "safe" in a row if the number of unknowns exceeds
\code{unknown.threshold} percent of the row total.}

\item{coalition}{maximum number of units in a possible coalition, default 1}

\item{suppressSmallCells}{logical variable which determines whether small cells (<= coalition) or large cells should be suppressed. Default FALSE.}

\item{...}{parameters from main suppression method}
}
\value{
list with two named elements, the first ($primary) being a logical vector
marking directly disclosive cells, the second ($numExtra) a data.frame containing
information regarding the dimensions in which the cells are directly disclosive.
}
\description{
Function for determining which cells in a frequency table can lead to
direct disclosure of an identifiable individual, assuming an attacker has the
background knowledge to place themselves (or a coalition) in the table.
}
\details{
This function does not work on data containing hierarchical variables.
}
\examples{
extable <- data.frame(v1 = rep(c('a', 'b', 'c'), times = 4),
            v2 = c('i','i', 'i','h','h','h','i','i','i','h','h','h'),
            v3 = c('y', 'y', 'y', 'y', 'y', 'y','z','z', 'z', 'z', 'z', 'z'),
            freq = c(0,0,5,0,2,3,1,0,3,1,1,2))
ex_freq <- c(18,10,8,9,5,4,9,5,4,2,0,2,1,0,1,1,0,1,3,2,1,3,2,1,0,0,0,13,8,5,
             5,3,2,8,5,3)
cross <- ModelMatrix(extable,
                     dimVar = 1:3,
                     crossTable = TRUE)$crossTable

FindDisclosiveCells(extable, ex_freq, cross) 
}
