% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/AutoHierarchies.R
\name{AutoHierarchies}
\alias{AutoHierarchies}
\alias{FindHierarchies}
\title{Ensure standardized coding of hierarchies}
\usage{
AutoHierarchies(hierarchies, data = NULL, total = "Total",
  hierarchyVarNames = c(mapsFrom = "mapsFrom", mapsTo = "mapsTo", sign =
  "sign", level = "level"), combineHierarchies = TRUE,
  unionComplement = FALSE)

FindHierarchies(data, total = "Total")
}
\arguments{
\item{hierarchies}{List of hierarchies}

\item{data}{Matrix or data frame with data containing codes of relevant variables}

\item{total}{Within \code{AutoHierarchies}: Vector of total codes (possibly recycled) used when running \code{\link{Hrc2DimList}}.}

\item{hierarchyVarNames}{Variable names in the hierarchy tables as in \code{\link{HierarchyFix}}}

\item{combineHierarchies}{Whether to combine several hierarchies for same variable into a single hierarchy}

\item{unionComplement}{Logical vector as in \code{\link{Hierarchies2ModelMatrix}}. The parameter is only in use when hierarchies are combined.}
}
\value{
List of hierarchies
}
\description{
Automatic convert list of hierarchies coded in different ways to standardized to-from coding
}
\details{
Input can be to-from coded hierarchies, hierarchies/dimList as in sdcTable, TauArgus coded hierarchies or formulas. 
Automatic coding from data is also supported. Output is on a from ready for input to \code{\link{HierarchyCompute}}.
\code{FindHierarchies} wraps \code{\link{FindDimLists}} and \code{AutoHierarchies} into a single function.
A single string as hierarchy input is assumed to be a total code. 
Then, the hierarchy is created as a simple hierarchy where all codes in data sum up to this total.
For consistence with \code{HierarchyCompute}, 
the codes \code{"rowFactor"} and \code{"colFactor"} are unchanged. 
An empty string is recoded to  \code{"rowFactor"}.
}
\examples{
# First, create different types of input
z <- SSBtoolsData("sprt_emp_withEU")
yearFormula <- c("y_14 = 2014", "y_15_16 = y_all - y_14", "y_all = 2014 + 2015 + 2016")
yearHier <- Formula2Hierarchy(yearFormula)
geoDimList <- FindDimLists(z[, c("geo", "eu")], total = "Europe")[[1]]
geoDimList2 <- FindDimLists(z[, c("geo", "eu")])[[1]]
geoHrc <- DimList2Hrc(geoDimList)
ageHier <- SSBtoolsData("sprt_emp_ageHier")

h1 <- AutoHierarchies(list(age = ageHier, geo = geoDimList, year = yearFormula))
h2 <- AutoHierarchies(list(age = "Y15-64", geo = geoHrc, year = yearHier), data = z, 
                      total = "Europe")
h3 <- AutoHierarchies(list(age = "Total", geo = geoDimList2, year = "Total"), data = z)
h4 <- FindHierarchies(z[, c(1, 2, 3, 5)])
h5 <- AutoHierarchies(list(age = "Total", geo = "", year = "colFactor"), data = z)
identical(h1, h2)
identical(h3, h4)

FindHierarchies(z[, c("geo", "eu", "age")])
}
\seealso{
\code{\link{DimList2Hierarchy}}, \code{\link{Hierarchy2Formula}}.
}
\author{
Øyvind Langsrud
}
