% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/guidance.R
\name{guide_SOAs}
\alias{guide_SOAs}
\title{Utility function for inspecting available SOAs for which the user need not provide an OA}
\usage{
guide_SOAs(s = 2, el = 3, m = NULL, n = NULL, ...)
}
\arguments{
\item{s}{required (default: 2); prime or prime power on which the SOA is based}

\item{el}{required (default: 3); the power to which \code{s} is to be taken,
i.e. the SOA will have columns with \code{s^el} levels}

\item{m}{the number of columns needed (optional)}

\item{n}{the maximum number of runs that are acceptable (optional);\cr
should be a multiple of \code{s^el}; must not be smaller than \code{m+1}, if \code{m} is specified}

\item{...}{currently unused}
}
\value{
The function returns a data frame, each row of which contains a possibility; if no SOAs exist, the data.frame has zero rows.
There is example code for constructing the SOA. Code details must be adjusted by the user
(see the documentation of the respective functions).
#'
}
\description{
Utility function for inspecting available SOAs for which the user need not provide an OA
}
\details{
The function provides the possible creation variants of an
SOA that has \code{m} columns in \code{s^el} levels in up to \code{n} runs.
It is permitted to specify \code{m} OR \code{n} only; in that case the function
provides constructions with the smallest \code{n} or the largest \code{m},
respectively.\cr
If both \code{m} and \code{n} are omitted, the function returns
the smallest possible (O)SOA constructions for \code{s^el} levels
that can be obtained without providing an OA.
}
\examples{
## guide_SOAs
## There is a Zhou and Tang type SOA with 4-level columns in 8 runs
guide_SOAs(2, 2, n=8)
## There are no SOAs with 8-level columns in 8 runs
guide_SOAs(2, 3, n=8)
## What SOAs based on s=2 in s^3 levels with 7 columns
## can be construct without providing an OA?
guide_SOAs(2, 3, m=7)
## pick the Shi and Tang family 3 design
myST_3plus <- SOAs_8level(n=32, m=7, constr='ShiTang_alphabeta')
## Note that the design has orthogonal columns and strength 3+,
## i.e., very good balance properties.

}
\references{
For full detail, see \code{\link{SOAs-package}}.

Groemping (2022)\cr
He, Cheng and Tang (2018)\cr
Li, Liu and Yang (2021)\cr
Shi and Tang (2020)\cr
Zhou and Tang (2019)\cr
}
\seealso{
\code{\link{guide_SOAs_from_OA}}
}
\author{
Ulrike Groemping
}
\keyword{array}
