% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utilitiesEvaluate.R
\name{ocheck}
\alias{ocheck}
\alias{ocheck3}
\alias{count_npairs}
\alias{count_nallpairs}
\alias{soacheck2D}
\alias{soacheck3D}
\title{functions to evaluate low order projection properties of (O)SOAs}
\usage{
ocheck(D, verbose = FALSE)

ocheck3(D, verbose = FALSE)

count_npairs(D, minn = 1)

count_nallpairs(ns)

soacheck2D(D, s = 3, el = 3, t = 3, verbose = FALSE)

soacheck3D(D, s = 3, el = 3, t = 3, verbose = FALSE)
}
\arguments{
\item{D}{a matrix with factor levels or an object of class \code{SOA};\cr
factor levels can start with 0 or with 1, and need to be consecutively numbered}

\item{verbose}{logical; if \code{TRUE}, additional information is printed
(confounded pair or triple projections with A2 or A3, respectively, or table of correlations)}

\item{minn}{small integer number; the function counts pairs that are covered at least \code{minn} times}

\item{ns}{vector of numbers of levels for each column}

\item{s}{the prime or prime power according to which the array is checked}

\item{el}{the exponent so that the number of levels of the array is \code{s^el}
(if \code{s} is not NULL)}

\item{t}{the strength for which to look (2, 3, or 4), equal to the sum of the
exponents in the stratification dimensions; for example, \code{soacheck2D} considers \cr
sxs 2D projections with \code{t=2}, \cr
s^2xs and sxs^2 projections with \code{t=3}, \cr
and s^3xs, s^2xs^2 and sxs^3 projections with \code{t=4}.\cr
If \code{t=4} and \code{el=2}, property gamma (s^3 x s and s x s^3) is obviously
impossible and will not be part of the checks.}
}
\value{
Functions whose names contain "\code{check}" return a logical.

Functions \code{count_npairs} and \code{count_npairs} return a vector of
counts for level combinations in factor pairs (in the order of the columns of
\code{DoE.base:::nchoosek(ncol(D),2)}), either for the array in D, or for
designs with numbers of levels given in \code{ns}.
}
\description{
soacheck2D and soacheck3D evaluate 2D and 3D projections, ocheck and ocheck3
evaluate pairwise or 3-orthogonality of columns, and count_npairs evaluates
the number of level pairs in 2D projections
}
\details{
Functions \code{soacheck2D} and \code{soacheck3D} inspect 2D and 3D
stratification, respectively. Each column must have \code{s^el} levels.
\code{t} specifies the degree of balance the functions are asked to look for.

Function \code{soacheck2D},
\itemize{
\item with el=t=2, looks for strength 2 conditions (s^2 levels, sxs balance),
\item with el=2, t=3, looks for strength 2+ / 3- conditions (s^2 levels, s^2xs balance),
\item with el=t=3, looks for strength 2* / 3 conditions (s^3 levels, s^2xs balance).
\item with el=2, t=4, looks for the enhanced strength 2+ / 3-  property alpha (s^2 levels, s^2xs^2 balance).
\item and with el=3, t=4, looks for strength 3+ / 4 conditions (s^3 levels, s^3xs and s^2xs^2 balance).
}

Function \code{soacheck3D},
\itemize{
\item with el=2, t=3, looks for strength 3- conditions (s^2 levels, sxsxs balance),
\item with el=t=3, looks for strength 3 conditions (s^3 levels, sxsxs balance),
\item and with el=3, t=4, looks for strength 3+ / 4 conditions (s^3 levels, s^2xsxs balance).
}

If \code{verbose=TRUE}, the functions print the pairs or triples that violate
the projection requirements for 2D or 3D.
}
\examples{
nullcase <- matrix(0:7, nrow=8, ncol=4)
soacheck2D(nullcase, s=2)
soacheck3D(nullcase, s=2)

## Shi and Tang strength 3+ construction in 7 8-level factors for 32 runs
D <- SOAs_8level(32, optimize=FALSE)

## check for strength 3+ (default el=3 is OK)
## 2D check
soacheck2D(D, s=2, t=4)
## 3D check
soacheck3D(D, s=2, t=4)
## not an OSOA
ocheck(D)

## an OSOA of strength 3 with 3-orthogonality
## 4 columns in 27 levels each
## second order model matrix

D_o <- OSOAs_LiuLiu(DoE.base::L81.3.10, optimize=FALSE)
ocheck3(D_o)

## benefit of 3-orthogonality for second order linear models
colnames(D_o) <- paste0("X", 1:4)
y <- stats::rnorm(81)
mylm <- stats::lm(y~(X1+X2+X3+X4)^2 + I(X1^2)+I(X2^2)+I(X3^2)+I(X4^2),
                   data=as.data.frame(scale(D_o, scale=FALSE)))
crossprod(stats::model.matrix(mylm))
}
\references{
For full detail, see \code{\link{SOAs-package}}.

Groemping (2021)\cr
He and Tang (2013)\cr
Shi and Tang (2020)
}
\author{
Ulrike Groemping
}
