% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/MDLEs.R
\name{MDLEs}
\alias{MDLEs}
\title{Function to create maximin distance level expanded arrays}
\usage{
MDLEs(
  oa,
  ell,
  noptim.rounds = 1,
  optimize = TRUE,
  noptim.oa = 1,
  dmethod = "manhattan",
  p = 50
)
}
\arguments{
\item{oa}{matrix or data.frame that contains an ingoing symmetric OA. Levels must be denoted as 0 to s-1 or as 1 to s.}

\item{ell}{the multiplier for each number of levels}

\item{noptim.rounds}{the number of optimization rounds; optimization may
take very long, therefore the default is 1, although more rounds are beneficial.}

\item{optimize}{logical: if \code{FALSE}, suppress optimization of expansion levels}

\item{noptim.oa}{integer: number of optimization rounds applied to initial oa itself before starting expansion}

\item{dmethod}{distance method for \code{\link{phi_p}}, "manhattan" (default) or "euclidean"}

\item{p}{p for \code{\link{phi_p}} (the larger, the closer to maximin distance)}
}
\value{
A matrix of class \code{MDLE} with attributes
\describe{
\item{phi_p}{the phi_p value that was achieved}
\item{type}{MDLE}
\item{optimized}{logical: same as the input parameter}
\item{call}{the call that produced the matrix}
\item{permpick}{matrix of lists of length \code{s} with elements from 0 to \code{ell}-1;\cr
matrix element (i,j) contains the sequence of replacements used in function \code{DcFromDp} for constructing the level expansion of the ith level in the jth column}
}
}
\description{
Maximin distance level expansion similar to Xiao and Xu is implemented,
using an optimization algorithm that is less demanding than the TA algorithm
of Xiao and Xu
}
\details{
The ingoing oa is possibly optimized for space-filling, using function \code{\link{phi_optimize}}
with \code{noptim.oa} optimization rounds. The expansions themselves are again optimized for improving phi_p,
using an algorithm which is a variant of Weng (2014), instead of the more powerful but also much more demanding
algorithm proposed by Xiao and Xu.
}
\examples{
dim(aus <- MDLEs(DoE.base::L16.4.5, 2, noptim.rounds = 1))
permpicks <- attr(aus, "permpick")
## for people interested in internal workings:
## the code below produces the same matrix as MDLEs
\donttest{SOAs:::DcFromDp(L16.4.5-1, 4,2, lapply(1:5, function(obj) permpicks[,obj]))}
}
\references{
For full detail, see \code{\link{SOAs-package}}.

Weng (2014)\cr
Xiao and Xu (2018)
}
\author{
Ulrike Groemping
}
