\name{snpgdsPCASampLoading}
\alias{snpgdsPCASampLoading}
\title{
	Sample loadings in principal component analysis
}
\description{
	To calculate the sample eigenvectors using the specified SNP loadings
}
\usage{
snpgdsPCASampLoading(loadobj, gdsobj, sample.id = NULL, num.thread = 1, verbose = TRUE)
}
\arguments{
	\item{loadobj}{the \code{snpgdsPCASNPLoadingClass} object, returned from \link{snpgdsPCASNPLoading}}
	\item{gdsobj}{the \code{\link[gdsfmt]{gdsclass}} object in the \link{gdsfmt} package}
	\item{sample.id}{a vector of sample id specifying selected samples; if NULL, all samples are used}
	\item{num.thread}{the number of CPU cores used}
	\item{verbose}{if TRUE, show information}
}
\details{
	the \code{sample.id} are usually different from the samples used in the calculation of SNP loadings.
}
\value{
	Return a \code{snpgdsPCAClass} object, and it is a list:
	\item{sample.id}{the sample ids used in the analysis}
	\item{snp.id}{the SNP ids used in the analysis}
	\item{eigenval}{eigenvalues}
	\item{eigenvect}{eigenvactors, ``# of samples'' x ``eigen.cnt''}
	\item{TraceXTX}{the trace of the genetic covariance matrix}
	\item{Bayesian}{whether use bayerisan normalization}
}
\references{
	Patterson N, Price AL, Reich D (2006) Population structure and eigenanalysis. PLoS Genetics 2:e190.

	Price AL, Patterson NJ, Plenge RM, Weinblatt ME, Shadick NA, Reich D (2006)
		Principal components analysis corrects for stratification in genome-wide association studies.
		Nat Genet. 38, 904-909.

	Zhu, X., Li, S., Cooper, R. S., and Elston, R. C. (2008). A unified association analysis
		approach for family and unrelated samples correcting for stratification.
		Am J Hum Genet, 82(2), 352-365.
}
\author{Xiuwen Zheng \email{zhengx@u.washington.edu}}
\seealso{
	\code{\link{snpgdsPCA}}, \code{\link{snpgdsPCACorr}}, \code{\link{snpgdsPCASNPLoading}}
}

\examples{
# open an example dataset (HapMap)
genofile <- openfn.gds(snpgdsExampleFileName())

sample.id <- read.gdsn(index.gdsn(genofile, "sample.id"))

PCARV <- snpgdsPCA(genofile, eigen.cnt=8, num.thread=2)
SnpLoad <- snpgdsPCASNPLoading(PCARV, genofile)

# calculate sample eigenvectors from SNP loadings
SL <- snpgdsPCASampLoading(SnpLoad, genofile, sample.id=sample.id[1:100])

diff <- PCARV$eigenvect[1:100,] - SL$eigenvect
summary(c(diff))

# close the genotype file
closefn.gds(genofile)
}

\keyword{gds}
\keyword{PCA}
\keyword{GWAS}
