% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Functions_L0_auxilary.R
\name{rcircle}
\alias{rcircle}
\title{Sample random points within a circle}
\usage{
rcircle(n = 1, radius = 1, uniform = TRUE, normScale = 1/3)
}
\arguments{
\item{n}{integer, number of samples points}

\item{radius}{numeric, radius of the sampled circle}

\item{uniform}{logical, should sampling be uniform or according to a
bi-variate spherical (uncorrelated) Gaussian distribution (see examples)}

\item{normScale}{numeric, if \code{uniform = FALSE}, a factor to scale radius
to standard deviation of the Gaussian density in x and in y (see examples)}
}
\value{
matrix with two columns for the x and y coordinates of the points.
}
\description{
Level 0 function that samples random points (x, y) within a
  circle via rejection sampling.
}
\examples{
x <- rcircle(n = 500)
lim <- range(x)
plot(x, xlim = lim, ylim = lim, main = "Uniform")

x <- rcircle(n = 500, uniform = FALSE)
lim <- range(x)
plot(x, xlim = lim, ylim = lim, main = "Gaussian")
}
\references{
nubDotDev (2021) The BEST Way to Find a Random Point in a Circle
https://youtu.be/4y_nmpv-9lI

Wolfram MathWorld (2023) Disk Point Picking
https://mathworld.wolfram.com/DiskPointPicking.html
}
