% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Functions_L0_auxilary.R
\name{nCaste}
\alias{nCaste}
\alias{nQueens}
\alias{nFathers}
\alias{nWorkers}
\alias{nDrones}
\alias{nVirginQueens}
\title{Level 0 function that returns the number of individuals of a caste in a
  colony}
\usage{
nCaste(x, caste = "all", simParamBee = NULL)

nQueens(x, simParamBee = NULL)

nFathers(x, simParamBee = NULL)

nWorkers(x, simParamBee = NULL)

nDrones(x, simParamBee = NULL)

nVirginQueens(x, simParamBee = NULL)
}
\arguments{
\item{x}{\code{\link[SIMplyBee]{Colony-class}} or \code{\link[SIMplyBee]{MultiColony-class}}}

\item{caste}{character, "queen", "fathers", "workers", "drones",
"virginQueens", or "all"}

\item{simParamBee}{\code{\link[SIMplyBee]{SimParamBee}}, global simulation parameters}
}
\value{
when \code{x} is \code{\link[SIMplyBee]{Colony-class}} return is integer for
  \code{caste != "all"} or list for \code{caste == "all"} with nodes named
  by caste; when \code{x} is \code{\link[SIMplyBee]{MultiColony-class}} return is named
  integer for \code{caste != "all"} or named list of lists for
  \code{caste == "all"}
}
\description{
Returns the number of individuals of a caste in a colony
}
\section{Functions}{
\itemize{
\item \code{nQueens()}: Number of queens in a colony

\item \code{nFathers()}: Number of fathers in a colony

\item \code{nWorkers()}: Number of workers in a colony

\item \code{nDrones()}: Number of drones in a colony

\item \code{nVirginQueens()}: Number of virgin queens in a colony

}}
\examples{
founderGenomes <- quickHaplo(nInd = 8, nChr = 1, segSites = 100)
SP <- SimParamBee$new(founderGenomes)
\dontshow{SP$nThreads = 1L}
basePop <- createVirginQueens(founderGenomes)

drones <- createDrones(x = basePop[1], nInd = 1000)
droneGroups <- pullDroneGroupsFromDCA(drones, n = 10, nDrones = nFathersPoisson)

# Create a Colony and a MultiColony class
colony <- createColony(x = basePop[2])
colony <- cross(colony, drones = droneGroups[[1]])
colony <- buildUp(x = colony, nWorkers = 100, nDrones = 10)
colony <- addVirginQueens(x = colony, nInd = 3)

apiary <- createMultiColony(basePop[3:4], n = 2)
apiary <- cross(apiary, drones = droneGroups[c(2, 3)])
apiary <- buildUp(x = apiary, nWorkers = 100, nDrones = 10)
apiary <- addVirginQueens(x = apiary, nInd = 3)

# Check caste members
nCaste(colony, caste = "queen")
nCaste(colony, caste = "fathers")
nCaste(colony, caste = "virginQueens")
nCaste(colony, caste = "workers")
nCaste(colony, caste = "drones")
nCaste(colony, caste = "all")

nCaste(apiary, caste = "queen")
nCaste(apiary, caste = "fathers")
nCaste(apiary, caste = "virginQueens")
nCaste(apiary, caste = "workers")
nCaste(apiary, caste = "drones")
nCaste(apiary, caste = "all")

# Check number of queens
nQueens(colony)
nQueens(apiary)
apiary <- removeQueen(apiary)
nQueens(apiary)

# Check number of fathers
nFathers(colony)
nFathers(apiary)

# Check number of workers
nWorkers(colony)
nWorkers(apiary)

# Check number of drones
nDrones(colony)
nDrones(apiary)

# Check number of virgin queens
nVirginQueens(colony)
nVirginQueens(apiary)

}
\seealso{
\code{\link[SIMplyBee]{nQueens}}, \code{\link[SIMplyBee]{nFathers}},
  \code{\link[SIMplyBee]{nVirginQueens}}, \code{\link[SIMplyBee]{nWorkers}}, and
  \code{\link[SIMplyBee]{nDrones}}
}
