% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Functions_L2_Colony.R
\name{setLocation}
\alias{setLocation}
\title{Set colony location}
\usage{
setLocation(x, location)
}
\arguments{
\item{x}{\code{\link{Colony-class}} or \code{\link{MultiColony-class}}}

\item{location}{numeric or list, location to be set for the
\code{\link{Colony-class}} or for \code{\link{MultiColony-class}}; when
numeric the same location will be set for all colonies; when list different
locations will be set for each colony - the list has to have the same
length at there are colonies in \code{x})}
}
\value{
\code{\link{Colony-class}} or \code{\link{MultiColony-class}} with set
  location
}
\description{
Level 2 function that to set a Colony or MultiColony object
  location to (x, y) coordinates.
}
\examples{
founderGenomes <- quickHaplo(nInd = 10, nChr = 1, segSites = 50)
SP <- SimParamBee$new(founderGenomes)
basePop <- createVirginQueens(founderGenomes)
drones <- createDrones(basePop[1], n = 1000)
droneGroups <- pullDroneGroupsFromDCA(drones, n = 10, nDrones = 10)

# Create Colony and MultiColony class
colony <- createColony(x = basePop[2])
colony <- cross(colony, drones = droneGroups[[1]])
apiary <- createMultiColony(basePop[3:8], n = 6)
apiary <- cross(apiary, drones = droneGroups[2:7])

getLocation(colony)
getLocation(apiary)

loc1 <- c(512, 722)
colony <- setLocation(colony, location = loc1)
getLocation(colony)

# Assuming one location (as in bringing colonies to one place!)
apiary <- setLocation(apiary, location = loc1)
getLocation(apiary)
}
