% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Class-SimParamBee.R
\name{nFathersPoisson}
\alias{nFathersPoisson}
\alias{nFathersTruncPoisson}
\title{Sample a number of fathers}
\usage{
nFathersPoisson(n = 1, average = 15)

nFathersTruncPoisson(n = 1, average = 15, lowerLimit = 0)
}
\arguments{
\item{n}{integer, number of samples}

\item{average}{numeric, average number of fathers}

\item{lowerLimit}{numeric, returned numbers will be above this value}
}
\value{
numeric, number of fathers
}
\description{
Sample a number of fathers - use when \code{nFathers = NULL}
  (see \code{\link{SimParamBee}$nFathers}).

  This is just an example. You can provide your own functions that satisfy
  your needs!
}
\details{
\code{nFathersPoisson} samples from a Poisson distribution, which
  can return a value 0 (that would mean a failed queen mating).

  \code{nFathersTruncPoisson} samples from a truncated Poisson distribution
  (truncated at zero) to avoid failed matings.
}
\section{Functions}{
\itemize{
\item \code{nFathersTruncPoisson()}: Sample a non-zero number of fathers

}}
\examples{
nFathersPoisson()
nFathersPoisson()
n <- nFathersPoisson(n = 1000)
hist(n, breaks = seq(from = min(n), to = max(n)), xlim = c(0, 40))
table(n)

nFathersTruncPoisson()
nFathersTruncPoisson()
n <- nFathersTruncPoisson(n = 1000)
hist(n, breaks = seq(from = min(n), to = max(n)), xlim = c(0, 40))
table(n)
}
\seealso{
\code{\link{SimParamBee}} field \code{nFathers}
}
