% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/norm.1972SF.R
\name{norm.1972SF}
\alias{norm.1972SF}
\title{Univariate Test of Normality by Shapiro and Francia (1972)}
\usage{
norm.1972SF(x)
}
\arguments{
\item{x}{a length-\eqn{n} data vector.}
}
\value{
a (list) object of \code{S3} class \code{htest} containing: \describe{
\item{statistic}{a test statistic.}
\item{p.value}{\eqn{p}-value under \eqn{H_0}.}
\item{alternative}{alternative hypothesis.}
\item{method}{name of the test.}
\item{data.name}{name(s) of provided sample data.}
}
}
\description{
Given an univariate sample \eqn{x}, it tests
\deqn{H_0 : x\textrm{ is from normal distribution} \quad vs\quad H_1 : \textrm{ not } H_0}
using a test procedure by Shapiro and Francia (1972), which is an approximation to Shapiro and Wilk (1965).
}
\examples{
## CRAN-purpose small example
x = rnorm(10)
norm.1972SF(x) # run the test

\donttest{
## generate samples from several distributions
x = stats::runif(496)            # uniform
y = stats::rgamma(496, shape=2)  # gamma
z = stats::rlnorm(496)           # log-normal

## test above samples
test.x = norm.1972SF(x) # uniform
test.y = norm.1972SF(y) # gamma
test.z = norm.1972SF(z) # log-normal
}

}
\references{
\insertRef{shapiro_approximate_1972}{SHT}
}
\concept{gof_normal}
