% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mean1.2008SD.R
\name{mean1.2008SD}
\alias{mean1.2008SD}
\title{One-sample Test for High-Dimensional Mean by Srivastava and Du (2008)}
\usage{
mean1.2008SD(X, mu0 = rep(0, ncol(X)))
}
\arguments{
\item{X}{an \eqn{(n\times p)} data matrix where each row is an observation.}

\item{mu0}{a length-\eqn{p} mean vector of interest.}
}
\value{
a (list) object of \code{S3} class \code{htest} containing: \describe{
\item{statistic}{a test statistic.}
\item{p.value}{\eqn{p}-value \eqn{P(H_0|H_1)} under current setting.}
\item{alternative}{alternative hypothesis.}
\item{method}{name of the test.}
\item{data.name}{name(s) of provided sample data.}
}
}
\description{
Given a multivariate sample \eqn{X} and hypothesized mean \eqn{\mu_0}, it tests
\deqn{H_0 : \mu_x = \mu_0\quad vs\quad H_1 : \mu_x \neq \mu_0}
using the procedure by Srivastava and Du (2008).
}
\examples{
## CRAN-purpose small example
smallX = matrix(rnorm(10*3),ncol=3)
mean1.2008SD(smallX) # run the test

\donttest{
## empirical Type 1 error 
niter   = 1000
counter = rep(0,niter)  # record p-values
for (i in 1:niter){
  X = matrix(rnorm(50*5), ncol=5)
  counter[i] = ifelse(mean1.2008SD(X)$p.value < 0.05, 1, 0)
}

## print the result
cat(paste("\\n* Example for 'mean1.2008SD'\\n\\n",
sprintf("* number of rejections   : \%d\\n",sum(counter)),
sprintf("* total number of trials : \%d\\n",niter),
sprintf("* empirical Type 1 error : \%.4f\\n", sum(counter/niter)),sep=""))
}

}
\references{
\insertRef{srivastava_test_2008}{SHT}
}
\author{
Kisung You
}
