% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plotQuartiles.R
\name{plotQuartiles}
\alias{plotQuartiles}
\title{Plot elicted quartiles, median and plausible range for each expert}
\usage{
plotQuartiles(
  vals,
  lower,
  upper,
  fs = 12,
  expertnames = NULL,
  xl = NULL,
  xlabel = "X"
)
}
\arguments{
\item{vals}{a matrix of elicited tertiles and medians: one column per expert, first 
row is the 25th percentile, 2nd row is the median, last row is the 75th percentile.}

\item{lower}{a vector of lower plausible limits: one per expert}

\item{upper}{a vector of upper plausible limits: one per expert}

\item{fs}{font size to be used in the plot}

\item{expertnames}{vector of experts' names}

\item{xl}{vector of limits for x-axis}

\item{xlabel}{x-axis label}
}
\description{
Displays a horizontal bar for each expert, to represent the expert's plausible range.
The coloured sections indicate the experts' quartiles: four intervals judged by the expert
to be equally likely. The experts' medians are shown as dashed lines.
}
\examples{
\dontrun{
l <- c(2, 1, 5, 1)
u <- c(95, 90, 65, 40)
v <- matrix(c(15, 25, 40,
 10, 20, 40,
 10, 15, 25,
 5, 10, 20),
 3, 4)
plotQuartiles(vals = v, lower = l, upper  = u)
}
}
\author{
Jeremy Oakley <j.oakley@sheffield.ac.uk>
}
