% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/check_stations.R
\name{nominal_station}
\alias{nominal_station}
\title{Check if stations are reported as nominal positions}
\usage{
nominal_station(data)
}
\arguments{
\item{data}{A data frame containing at least the columns:
\code{sample_date}, \code{station_name},
\code{sample_longitude_dd}, and \code{sample_latitude_dd}.}
}
\value{
A data frame with distinct station names and their corresponding
latitude/longitude positions, if nominal positions are suspected.
Otherwise, returns \code{NULL}.
}
\description{
\ifelse{html}{\href{https://lifecycle.r-lib.org/articles/stages.html#deprecated}{\figure{lifecycle-deprecated.svg}{options: alt='[Deprecated]'}}}{\strong{[Deprecated]}}
This function is deprecated and has been replaced by \code{\link[=check_nominal_station]{check_nominal_station()}}.
}
\details{
This function attempts to determine whether stations in a dataset are reported
using nominal positions (i.e., generic or repeated coordinates across events),
rather than actual measured coordinates. It compares the number of unique
sampling dates with the number of unique station coordinates.

If the number of unique sampling dates is larger than the number of unique
station coordinates, the function suspects nominal station positions and
issues a warning.
}
\examples{
\donttest{
df <- data.frame(
  sample_date = rep(seq.Date(Sys.Date(), by = "day", length.out = 3), each = 2),
  station_name = rep(c("ST1", "ST2"), 3),
  sample_longitude_dd = rep(c(15.0, 16.0), 3),
  sample_latitude_dd = rep(c(58.5, 58.6), 3)
)
nominal_station(df)
}

}
\keyword{internal}
