% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/nua_api_functions.R
\name{get_nua_taxa}
\alias{get_nua_taxa}
\title{Retrieve taxa information from Nordic Microalgae}
\usage{
get_nua_taxa(unparsed = FALSE)
}
\arguments{
\item{unparsed}{Logical. If \code{TRUE}, complete API response is returned as an unparsed list. Default is \code{FALSE}.}
}
\value{
When unparsed = \code{FALSE}: a \code{tibble} containing the following columns:
\item{slug}{A unique identifier for the taxon.}
\item{scientific_name}{The scientific name of the taxon.}
\item{authority}{The authority associated with the scientific name.}
\item{rank}{The taxonomic rank of the taxon.}
}
\description{
This function retrieves all taxonomic information for algae taxa from the Nordic Microalgae API.
It fetches details including scientific names, authorities, ranks, and image URLs (in different sizes: large, medium, original, and small).
}
\examples{
\donttest{
  # Retrieve and display taxa data
  taxa_data <- get_nua_taxa(unparsed = FALSE)
  head(taxa_data)
}

}
\seealso{
\url{https://nordicmicroalgae.org/} for Nordic Microalgae website.

\url{https://nordicmicroalgae.org/api/} for Nordic Microalgae API documentation.
}
