% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/SHAP_funcs.R
\name{shap.prep.stack.data}
\alias{shap.prep.stack.data}
\title{Prepare data for SHAP force plot (stack plot).}
\usage{
shap.prep.stack.data(shap_contrib, top_n = NULL, data_percent = 1,
  cluster_method = "ward.D", n_groups = 10L)
}
\arguments{
\item{shap_contrib}{shap_contrib is the SHAP value data returned from predict.xgb.booster}

\item{top_n}{integer, optional to show only top_n features, combine the rest}

\item{data_percent}{what percent of data to plot (to speed up), in the range of (0,1]}

\item{cluster_method}{default to ward.D}

\item{n_groups}{a integer, how many groups to plot in \code{\link{shap.plot.force_plot_bygroup}}}
}
\value{
a dataset for stack plot
}
\description{
Make force plot for \code{top_n} features, option to randomly
plot p*100 percent of the data in case the dataset is large.
}
\examples{

# **SHAP force plot**
plot_data <- shap.prep.stack.data(shap_contrib = shap_values_iris,
                                  n_groups = 4)
shap.plot.force_plot(plot_data)
shap.plot.force_plot(plot_data,  zoom_in_group = 2)

# plot all the clusters:
shap.plot.force_plot_bygroup(plot_data)
}
