% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/graphID.R
\name{graphID.genericID}
\alias{graphID.genericID}
\title{Determine generic identifiability of a mixed graph.}
\usage{
graphID.genericID(L, O)
}
\arguments{
\item{L}{Adjacency matrix for the directed part of the path
diagram/mixed graph; an edge pointing from i to j is encoded as L[i,j]=1 and
the lack of an edge between i and j is encoded as L[i,j]=0. There should be
no directed self loops, i.e. no i such that L[i,i]=1.}

\item{O}{Adjacency matrix for the bidirected part of the path diagram/mixed
graph. Edges are encoded as for the L parameter. Again there should be no
self loops. Also this matrix will be coerced to be symmetric so it is only
necessary to specify an edge once, i.e. if O[i,j]=1 you may, but are not
required to, also have O[j,i]=1.}
}
\value{
The vector of nodes that could be determined to be generically
identifiable.
}
\description{
If directed part of input graph is cyclic then will check for generic
identifiability using the half-trek criterion. Otherwise will use the a
slightly stronger version of the half-trek criterion using ancestor
decompositions.
}
\references{
Foygel, R., Draisma, J., and Drton, M.  (2012) Half-trek criterion for
generic identifiability of linear structural equation models.
\emph{Ann. Statist.} 40(3): 1682-1713.

{Drton}, M. and {Weihs}, L. (2015) Generic Identifiability of Linear
Structural Equation Models by Ancestor Decomposition. arXiv 1504.02992
}
