% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/em_reml.R
\name{estimate.vc}
\alias{estimate.vc}
\title{REML EM Algorithm}
\usage{
estimate.vc(
  y,
  Xtilde,
  qrXtilde,
  beta,
  G,
  init.sigma = 0.5,
  init.tau = 0.5,
  tol = 0.001,
  maxiters = 1000
)
}
\arguments{
\item{y}{Vector of observed phenotypes}

\item{Xtilde}{Matrix of covariates (first column contains the intercept, last column contains the E factor for studying the GxE effect)}

\item{qrXtilde}{Object containing QR decomposition of Xtilde}

\item{beta}{Coefficient vector for covariate matrix Xtilde}

\item{G}{Matrix of genotype markers}

\item{init.sigma}{Initial sigma input (Default is 0.5)}

\item{init.tau}{Initial tau input (Default is 0.5)}

\item{tol}{Tolerance for convergence (Default is 1e-3)}

\item{maxiters}{Maximum number of iterations (Default is 1000)}
}
\value{
Estimates for tau and sigma
}
\description{
REML EM algorithm for estimating variance components
}
