% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/aicc.R
\name{aicc}
\alias{aicc}
\title{AICc}
\usage{
aicc(model, env, parallel = FALSE)
}
\arguments{
\item{model}{\linkS4class{SDMmodel} object.}

\item{env}{\code{\link[raster]{stack}} containing the environmental
variables.}

\item{parallel}{logical, if \code{TRUE} it uses parallel computation, default
is \code{FALSE}.}
}
\value{
The computed AICc
}
\description{
Compute the Akaike Information Criterion corrected for small samples size
(Warren and Seifert, 2011).
}
\details{
Parallel computation increases the speed only for large datasets due
to the time necessary to create the cluster.
}
\examples{
# Acquire environmental variables
files <- list.files(path = file.path(system.file(package = "dismo"), "ex"),
                    pattern = "grd", full.names = TRUE)
predictors <- raster::stack(files)

# Prepare presence locations
p_coords <- condor[, 1:2]

# Prepare background locations
bg_coords <- dismo::randomPoints(predictors, 5000)

# Create SWD object
presence <- prepareSWD(species = "Vultur gryphus", coords = p_coords,
                       env = predictors, categorical = "biome")
bg <- prepareSWD(species = "Vultur gryphus", coords = bg_coords,
                 env = predictors, categorical = "biome")

# Train a model
model <- train(method = "Maxnet", p = presence, a = bg, fc = "l")

# Compute the AICc
aicc(model, predictors)

\donttest{
# Compute the AICc using parallel computation. This reduces the time only for
# large datasets, in this case it takes longer than the previous example due
# to the time used to start and stop a cluster
aicc(model, predictors, parallel = TRUE)
}
}
\references{
Warren D.L., Seifert S.N., (2011). Ecological niche modeling in
Maxent: the importance of model complexity and the performance of model
selection criteria. Ecological Applications, 21(2), 335–342.
}
\author{
Sergio Vignali
}
