% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dm_functions.R
\name{SDALGCPRegularPoint}
\alias{SDALGCPRegularPoint}
\title{SDALGCPRegularPoint function}
\usage{
SDALGCPRegularPoint(poly, delta, weighted = FALSE, pop_shp = NULL,
  lambdamax = NULL, pop = NULL, n = NULL, rho = NULL,
  giveup = NULL, bound = NULL)
}
\arguments{
\item{poly}{polygon in which to generate the points}

\item{delta}{distance between points}

\item{weighted}{To specify if you want to use the population density, default to FALSE, i.e population density is not used.}

\item{pop_shp}{Optional, The raster of population density map for population weighted approach.}

\item{lambdamax}{the maximum value of the population density in the polygon}

\item{pop}{the population density.}

\item{n}{optional; the number of points to create in the polygon, if not supplied, it is computed as \eqn{n = rho*|A|*4/(\pi*delta^2)}}

\item{rho}{Optional, The packing density, default set to 0.55}

\item{giveup}{Number of rejected proposals after which the algorithm should terminate.}

\item{bound}{Spatial object; the boundary of the polygon}
}
\value{
It returns a list of the coordinates of the points created in each polygon.
}
\description{
This function generate a random point pattern using a regular (systematically aligned) sampling. An internal function for \code{\link{SDALGCP}} package.
}
\details{
This algorithm generates points inside the polygon using a regular (systematically aligned) sampling.
}
\examples{
data(PBCshp)
require(sp)   #load sp package
poly <- PBCshp@polygons[[1]]@Polygons[[1]]@coords
#create a spatialpolygons object
bound <- SpatialPolygons(list(Polygons(list(Polygon(poly)), "x")))
point <- SDALGCPRegularPoint(poly=poly, delta=100, n=1, bound = bound)
}
\author{
Olatunji O. Johnson \email{o.johnson@lancaster.ac.uk}

Emanuele Giorgi \email{e.giorgi@lancaster.ac.uk}

Peter J. Diggle \email{p.diggle@lancaster.ac.uk}
}
\keyword{internal}
