% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/do_BoxPlot.R
\name{do_BoxPlot}
\alias{do_BoxPlot}
\title{Generate Box Plots.}
\usage{
do_BoxPlot(
  sample,
  feature,
  group.by = NULL,
  split.by = NULL,
  assay = NULL,
  slot = "data",
  font.size = 14,
  font.type = "sans",
  rotate_x_axis_labels = 45,
  colors.use = NULL,
  na.value = "grey75",
  plot.title = NULL,
  plot.subtitle = NULL,
  plot.caption = NULL,
  xlab = NULL,
  ylab = NULL,
  legend.title = if (is.null(split.by)) {
     if (is.null(group.by)) {
        
    "Groups"
     }
     else {
         group.by
     }
 } else {
     split.by
 },
  legend.title.position = "top",
  legend.position = if (is.null(split.by)) {
     "none"
 } else {
     "bottom"
 },
  boxplot.line.color = "black",
  outlier.color = "black",
  outlier.alpha = 0.5,
  boxplot.linewidth = 1,
  boxplot.width = NULL,
  plot.grid = TRUE,
  grid.color = "grey75",
  grid.type = "dashed",
  flip = FALSE,
  order = FALSE,
  use_silhouette = FALSE,
  use_test = FALSE,
  comparisons = NULL,
  test = "wilcox.test",
  map_signif_level = TRUE
)
}
\arguments{
\item{sample}{\strong{\code{\link[SeuratObject]{Seurat}}} | A Seurat object, generated by \link[Seurat]{CreateSeuratObject}.}

\item{feature}{\strong{\code{\link[base]{character}}} | Feature to represent.}

\item{group.by}{\strong{\code{\link[base]{character}}} | Metadata variable to group the output by. Has to be a character of factor column.}

\item{split.by}{\strong{\code{\link[base]{character}}} | Secondary metadata variable to further group (split) the output by. Has to be a character of factor column.}

\item{assay}{\strong{\code{\link[base]{character}}} | Assay to use. Defaults to the current assay.}

\item{slot}{\strong{\code{\link[base]{character}}} | Data slot to use. Only one of: counts, data, scale.data. Defaults to "data".}

\item{font.size}{\strong{\code{\link[base]{numeric}}} | Overall font size of the plot. All plot elements will have a size relationship with this font size.}

\item{font.type}{\strong{\code{\link[base]{character}}} | Base font family for the plot. One of:
\itemize{
\item \emph{\code{mono}}: Mono spaced font.
\item \emph{\code{serif}}: Serif font family.
\item \emph{\code{sans}}: Default font family.
}}

\item{rotate_x_axis_labels}{\strong{\code{\link[base]{numeric}}} | Degree to rotate the X labels. One of: 0, 45, 90.}

\item{colors.use}{\strong{\code{\link[SCpubr]{named_vector}}} | Named vector of valid color representations (either name of HEX codes) with as many named colors as unique values of group.by. If group.by is not provided, defaults to the unique values of \link[Seurat]{Idents}. If not provided, a color scale will be set by default.}

\item{na.value}{\strong{\code{\link[base]{character}}} | Color value for NA.}

\item{plot.title, plot.subtitle, plot.caption}{\strong{\code{\link[base]{character}}} | Title, subtitle or caption to use in the plot.}

\item{xlab, ylab}{\strong{\code{\link[base]{character}}} | Titles for the X and Y axis.}

\item{legend.title}{\strong{\code{\link[base]{character}}} | Title for the legend.}

\item{legend.title.position}{\strong{\code{\link[base]{character}}} | Position for the title of the legend. One of:
\itemize{
\item \emph{\code{top}}: Top of the legend.
\item \emph{\code{bottom}}: Bottom of the legend.
\item \emph{\code{left}}: Left of the legend.
\item \emph{\code{right}}: Right of the legend.
}}

\item{legend.position}{\strong{\code{\link[base]{character}}} | Position of the legend in the plot. One of:
\itemize{
\item \emph{\code{top}}: Top of the figure.
\item \emph{\code{bottom}}: Bottom of the figure.
\item \emph{\code{left}}: Left of the figure.
\item \emph{\code{right}}: Right of the figure.
\item \emph{\code{none}}: No legend is displayed.
}}

\item{boxplot.line.color}{\strong{\code{\link[base]{character}}} | Color of the borders of the boxplots if use_silhouette is FALSE.}

\item{outlier.color}{\strong{\code{\link[base]{character}}} | Color of the outlier dots.}

\item{outlier.alpha}{\strong{\code{\link[base]{numeric}}} | Alpha applied to the outliers.}

\item{boxplot.linewidth}{\strong{\code{\link[base]{numeric}}} | Width of the lines in the boxplots. Also controls the lines of the tests applied if use_test is set to true.}

\item{boxplot.width}{\strong{\code{\link[base]{numeric}}} | Width of the boxplots.}

\item{plot.grid}{\strong{\code{\link[base]{logical}}} | Whether to plot grid lines.}

\item{grid.color}{\strong{\code{\link[base]{character}}} | Color of the grid in the panels.}

\item{grid.type}{\strong{\code{\link[base]{character}}} | One of the possible linetype options:
\itemize{
\item \emph{\code{blank}}.
\item \emph{\code{solid}}.
\item \emph{\code{dashed}}.
\item \emph{\code{dotted}}.
\item \emph{\code{dotdash}}.
\item \emph{\code{longdash}}.
\item \emph{\code{twodash}}.
}}

\item{flip}{\strong{\code{\link[base]{logical}}} | Whether to invert the axis of the displayed plot.}

\item{order}{\strong{\code{\link[base]{logical}}} | Whether to order the boxplots by average values. Can not be used alongside split.by.}

\item{use_silhouette}{\strong{\code{\link[base]{logical}}} | Whether to color the borders of the boxplots instead of the inside area.}

\item{use_test}{\strong{\code{\link[base]{logical}}} | Whether to apply a statistical test to a given pair of elements. Can not be used alongside split.by.}

\item{comparisons}{A list of length-2 vectors. The entries in the vector are
either the names of 2 values on the x-axis or the 2 integers that
correspond to the index of the columns of interest.}

\item{test}{the name of the statistical test that is applied to the values of
the 2 columns (e.g. \code{t.test}, \code{wilcox.test} etc.). If you implement a
custom test make sure that it returns a list that has an entry called
\code{p.value}.}

\item{map_signif_level}{Boolean value, if the p-value are directly written as
annotation or asterisks are used instead. Alternatively one can provide a
named numeric vector to create custom mappings from p-values to annotation:
For example: \code{c("***"=0.001, "**"=0.01, "*"=0.05)}.
Alternatively, one can provide a function that takes a numeric argument
(the p-value) and returns a string.}
}
\value{
A ggplot2 object.
}
\description{
Generate Box Plots.
}
\examples{
\donttest{
  # Check Suggests.
  value <- SCpubr:::check_suggests(function_name = "do_BoxPlot", passive = TRUE)

  if (isTRUE(value)){
    # Consult the full documentation in https://enblacar.github.io/SCpubr-book/

    # Define your Seurat object.
    sample <- readRDS(system.file("extdata/seurat_dataset_example.rds", package = "SCpubr"))

    # Basic box plot.
    p <- SCpubr::do_BoxPlot(sample = sample,
                            feature = "nCount_RNA")
    p

    # Use silhouette style.
    p <- SCpubr::do_BoxPlot(sample = sample,
                            feature = "nCount_RNA",
                            use_silhouette = TRUE)
    p

    # Order by mean values.
    p <- SCpubr::do_BoxPlot(sample = sample,
                            feature = "nCount_RNA",
                            order = TRUE)
    p

    # Apply second grouping.
    sample$orig.ident <- ifelse(sample$seurat_clusters \%in\% c("0", "1", "2", "3"), "A", "B")
    p <- SCpubr::do_BoxPlot(sample = sample,
                            feature = "nCount_RNA",
                            split.by = "orig.ident")
    p

    # Apply statistical tests.
    p <- SCpubr::do_BoxPlot(sample = sample,
                            feature = "nCount_RNA",
                            group.by = "orig.ident",
                            use_test = TRUE,
                            comparisons = list(c("A", "B")))
    p

  } else if (isFALSE(value)){
    message("This function can not be used without its suggested packages.")
    message("Check out which ones are needed using `SCpubr::state_dependencies()`.")
  }
}
}
