% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/do_CorrelationPlot.R
\name{do_CorrelationPlot}
\alias{do_CorrelationPlot}
\title{Create correlation matrix heatmaps.}
\usage{
do_CorrelationPlot(
  sample,
  mode = "hvg",
  assay = NULL,
  group.by = NULL,
  column_title = "",
  row_title = "",
  cluster_cols = TRUE,
  cluster_rows = TRUE,
  legend.title = "Pearson coef.",
  row_names_rot = 0,
  column_names_rot = 0,
  viridis_color_map = "G",
  cell_size = 5,
  na.value = "grey75",
  legend.position = "bottom",
  legend.length = 75,
  legend.width = 5,
  legend.framecolor = "black"
)
}
\arguments{
\item{sample}{\strong{\code{\link[SeuratObject]{Seurat}}} | A Seurat object, generated by \link[Seurat]{CreateSeuratObject}.}

\item{mode}{\strong{\code{\link[base]{character}}} | Different types of correlation matrices can be computed. Right now, the only possible value is "hvg", standing for Highly Variable Genes. The sample is subset for the HVG and the data is re-scaled. Scale data is used for the correlation.}

\item{assay}{\strong{\code{\link[base]{character}}} | Assay to use. Defaults to the current assay.}

\item{group.by}{\strong{\code{\link[base]{character}}} | Metadata variable to group the output by. Has to be a character of factor column.}

\item{column_title}{\strong{\code{\link[base]{character}}} | Title for the columns of the heatmaps. Only works with single heatmaps.}

\item{row_title}{\strong{\code{\link[base]{character}}} | Title for the rows of the heatmaps. Only works with single heatmaps.}

\item{cluster_cols, cluster_rows}{\strong{\code{\link[base]{logical}}} | Cluster the columns or rows of the heatmaps.}

\item{legend.title}{\strong{\code{\link[base]{character}}} | Title for the legend.}

\item{column_names_rot, row_names_rot}{\strong{\code{\link[base]{numeric}}} | Degree in which to rotate the column and row labels.}

\item{viridis_color_map}{\strong{\code{\link[base]{character}}} | A capital letter from A to H or the scale name as in \link[viridis]{scale_fill_viridis}.}

\item{cell_size}{\strong{\code{\link[base]{numeric}}} | Size of each cell in the heatmap.}

\item{na.value}{\strong{\code{\link[base]{character}}} | Color value for NA.}

\item{legend.position}{\strong{\code{\link[base]{character}}} | Position of the legend in the plot. One of:
\itemize{
\item \emph{\code{top}}: Top of the figure.
\item \emph{\code{bottom}}: Bottom of the figure.
\item \emph{\code{left}}: Left of the figure.
\item \emph{\code{right}}: Right of the figure.
\item \emph{\code{none}}: No legend is displayed.
}}

\item{legend.length, legend.width}{\strong{\code{\link[base]{numeric}}} | Length and width of the legend. Will adjust automatically depending on legend side.}

\item{legend.framecolor}{\strong{\code{\link[base]{character}}} | Color of the lines of the box in the legend.}
}
\value{
A ComplexHeatmap object.
}
\description{
Create correlation matrix heatmaps.
}
\examples{
\donttest{
  # Check Suggests.
  value <- SCpubr:::check_suggests(function_name = "do_CorrelationPlot", passive = TRUE)

  if (isTRUE(value)){
    # Define your Seurat object.
    sample <- readRDS(system.file("extdata/seurat_dataset_example.rds", package = "SCpubr"))

    # Default values.
    p <- SCpubr::do_CorrelationPlot(sample = sample)
    p

    # Custom grouping.
    clusters <- c("1", "3", "5", "7", "9")
    sample$custom_group <- ifelse(sample$seurat_clusters \%in\% clusters,
                                  "Group A",
                                  "Group B")
    p <- SCpubr::do_CorrelationPlot(sample = sample, group.by = "custom_group")
    p

    # Rotated axis labels.
    p <- SCpubr::do_CorrelationPlot(sample = sample,
                                    column_names_rot = 0)
    p

    # Increase cell size and rotate axis labels.
    p <- SCpubr::do_CorrelationPlot(sample = sample,
                                    column_names_rot = 0,
                                    cell_size = 7)
    p
  } else if (isFALSE(value)){
    message("This function can not be used without its suggested packages.")
    message("Check out which ones are needed using `SCpubr::state_dependencies()`.")
  }
}

}
